/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items;

import com.herocraftonline.heroes.items.ComplexItemMatcher;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

public class WeaponConfig
implements ConfigurationSerializable {
    public static final String MATCHER_SERIALIZATION_KEY = "matcher";
    public static final String KNOCKBACK_SERIALIZATION_KEY = "knockback-level";
    public static final String PENETRATION_SERIALIZATION_KEY = "penetration-percent";
    public static final String REACH_SERIALIZATION_KEY = "reach-distance";
    private final ComplexItemMatcher matcher;
    private final float knockback;
    private final float penetration;
    private final float reach;

    public WeaponConfig(ComplexItemMatcher matcher, float knock, float pen, float dist) {
        this.matcher = matcher;
        this.knockback = knock;
        this.penetration = pen;
        this.reach = dist;
    }

    public WeaponConfig(Map<String, Object> serialized) {
        this.matcher = (ComplexItemMatcher)serialized.getOrDefault(MATCHER_SERIALIZATION_KEY, new ComplexItemMatcher("", ""));
        this.knockback = ((Float)serialized.getOrDefault(KNOCKBACK_SERIALIZATION_KEY, Float.valueOf(0.5f))).floatValue();
        this.penetration = ((Float)serialized.getOrDefault(PENETRATION_SERIALIZATION_KEY, 0)).floatValue();
        this.reach = ((Float)serialized.getOrDefault(REACH_SERIALIZATION_KEY, Float.valueOf(3.0f))).floatValue();
    }

    public ComplexItemMatcher getMatcher() {
        return this.matcher;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public float getPenetration() {
        return this.penetration;
    }

    public float getReach() {
        return this.reach;
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> mapSerializer = new HashMap<String, Object>();
        mapSerializer.put(MATCHER_SERIALIZATION_KEY, this.matcher.serialize());
        mapSerializer.put(KNOCKBACK_SERIALIZATION_KEY, Float.valueOf(this.knockback));
        mapSerializer.put(PENETRATION_SERIALIZATION_KEY, Float.valueOf(this.penetration));
        mapSerializer.put(REACH_SERIALIZATION_KEY, Float.valueOf(this.reach));
        return mapSerializer;
    }
}

