/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ComplexItemMatcher
implements ConfigurationSerializable {
    public static final String NAME_MATCH_SERIALIZATION_KEY = "name-match";
    public static final String TYPE_MATCH_SERIALIZATION_KEY = "type-match";
    private final String nameMatch;
    private final String typeMatch;
    private final boolean considerLore;

    public ComplexItemMatcher(String nameMatch, String typeMatch) {
        this.nameMatch = nameMatch;
        this.typeMatch = typeMatch;
        this.considerLore = false;
    }

    public ComplexItemMatcher(String nameMatch, String typeMatch, boolean considerLore) {
        this.nameMatch = nameMatch;
        this.typeMatch = typeMatch;
        this.considerLore = considerLore;
    }

    public ComplexItemMatcher(Map<String, Object> serialized) {
        this.nameMatch = (String)serialized.getOrDefault(NAME_MATCH_SERIALIZATION_KEY, "");
        this.typeMatch = (String)serialized.getOrDefault(TYPE_MATCH_SERIALIZATION_KEY, "");
        this.considerLore = false;
    }

    public boolean hasBothMatches() {
        return this.hasNameMatch() && this.hasTypeMatch();
    }

    public boolean hasNameMatch() {
        return this.nameMatch != null && this.nameMatch.length() > 1;
    }

    public boolean hasTypeMatch() {
        return this.typeMatch != null && this.typeMatch.length() > 1;
    }

    public String getNameMatch() {
        return this.nameMatch;
    }

    public String getTypeMatch() {
        return this.typeMatch;
    }

    public boolean isAMatch(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (this.hasBothMatches()) {
            if (!item.getType().name().contains(this.typeMatch)) {
                return false;
            }
            ItemMeta meta = item.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return false;
            }
            return meta.getDisplayName().contains(this.nameMatch) || this.matchLore(item);
        }
        if (this.hasNameMatch()) {
            ItemMeta meta = item.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return false;
            }
            return meta.getDisplayName().contains(this.nameMatch) || this.matchLore(item);
        }
        if (this.hasTypeMatch()) {
            return item.getType().name().contains(this.typeMatch);
        }
        return false;
    }

    private boolean matchLore(ItemStack item) {
        ItemMeta meta;
        boolean isMatch = false;
        if (this.considerLore && (meta = item.getItemMeta()) != null && meta.hasLore()) {
            List lore = meta.getLore();
            for (String line : lore) {
                if (!line.contains(this.nameMatch)) continue;
                isMatch = true;
                break;
            }
        }
        return isMatch;
    }

    public static ComplexItemMatcher deserialize(Map<String, Object> map) {
        return new ComplexItemMatcher(map);
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> mapSerializer = new HashMap<String, Object>();
        mapSerializer.put(NAME_MATCH_SERIALIZATION_KEY, this.nameMatch);
        mapSerializer.put(TYPE_MATCH_SERIALIZATION_KEY, this.typeMatch);
        return mapSerializer;
    }
}

