/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.integrations.citizens;

import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;

public class HeroesNPCTrait
extends Trait {
    @Persist
    String primaryClass;
    @Persist
    String secondaryClass;
    @Persist
    String raceClass;
    @Persist
    String cooldowns;
    @Persist
    String experience;
    @Persist
    String mastered;

    public HeroesNPCTrait() {
        super("HeroesNPC");
    }

    public String getPrimaryClass() {
        return this.primaryClass;
    }

    public void setPrimaryClass(HeroClass hClass) {
        this.primaryClass = hClass.getName();
    }

    public String getSecondaryClass() {
        return this.secondaryClass;
    }

    public void setSecondaryClass(HeroClass hClass) {
        if (hClass == null) {
            this.secondaryClass = null;
            return;
        }
        this.secondaryClass = hClass.getName();
    }

    public String getRaceClass() {
        return this.raceClass;
    }

    public void setRaceClass(HeroClass hClass) {
        if (hClass == null) {
            this.raceClass = null;
            return;
        }
        this.raceClass = hClass.getName();
    }

    public Map<String, String> getExperience() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.experience != null && !this.experience.equals("")) {
            for (String parse : this.experience.split("::")) {
                ret.put(parse.split(":")[0], parse.split(":")[1]);
            }
        }
        return ret;
    }

    public void setExperience(Map<String, Double> exp) {
        if (exp == null) {
            this.experience = null;
            return;
        }
        StringBuilder sB = new StringBuilder();
        boolean nFirst = false;
        for (Map.Entry<String, Double> e : exp.entrySet()) {
            if (nFirst) {
                sB.append("::");
            } else {
                nFirst = true;
            }
            sB.append(e.getKey());
            sB.append(":");
            sB.append(e.getValue().toString());
        }
        this.experience = sB.toString();
    }

    public Collection<String> getMastered() {
        if (this.mastered != null && !this.mastered.equals("")) {
            return Arrays.asList(this.mastered.split(":"));
        }
        return new HashSet<String>();
    }

    public void setMastered(Collection<String> mastered) {
        if (mastered == null) {
            this.mastered = null;
            return;
        }
        StringBuilder sB = new StringBuilder();
        boolean nFirst = false;
        for (String string : mastered) {
            if (nFirst) {
                sB.append(":");
            } else {
                nFirst = true;
            }
            sB.append(string);
        }
        this.mastered = sB.toString();
    }

    public Map<String, String> getCooldowns() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.cooldowns != null && !this.cooldowns.equals("")) {
            for (String parse : this.cooldowns.split("::")) {
                ret.put(parse.split(":")[0], parse.split(":")[1]);
            }
        }
        return ret;
    }

    public void setCooldowns(Map<String, Long> cd) {
        if (cd == null) {
            this.cooldowns = null;
            return;
        }
        StringBuilder sB = new StringBuilder();
        boolean nFirst = false;
        for (Map.Entry<String, Long> e : cd.entrySet()) {
            if (nFirst) {
                sB.append("::");
            } else {
                nFirst = true;
            }
            sB.append(e.getKey());
            sB.append(":");
            sB.append(e.getValue().toString());
        }
        this.cooldowns = sB.toString();
    }
}

