/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.integrations.citizens;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.integrations.citizens.CitizensHero;
import com.herocraftonline.heroes.integrations.citizens.HeroesNPCTrait;
import com.herocraftonline.heroes.storage.Storage;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CitizensTraitStorage
extends Storage {
    public CitizensTraitStorage(Heroes plugin) {
        super(plugin, "CitizensTraitStorage");
    }

    @Override
    public Hero loadHero(Player player) {
        HeroesNPCTrait trait;
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)player);
        if (!npc.hasTrait(HeroesNPCTrait.class)) {
            npc.addTrait(HeroesNPCTrait.class);
        }
        HeroClass heroClass = (trait = (HeroesNPCTrait)npc.getTrait(HeroesNPCTrait.class)).getPrimaryClass() == null ? this.plugin.getClassManager().getDefaultClass() : this.plugin.getClassManager().getClass(trait.getPrimaryClass());
        HeroClass secondClass = trait.getSecondaryClass() != null ? this.plugin.getClassManager().getClass(trait.getSecondaryClass()) : null;
        HeroClass raceClass = trait.getRaceClass() != null ? this.plugin.getClassManager().getClass(trait.getRaceClass()) : null;
        CitizensHero hero = new CitizensHero(this.plugin, player, this, heroClass, secondClass, raceClass);
        try {
            if (trait.getCooldowns() != null) {
                for (Map.Entry<String, String> entry : trait.getCooldowns().entrySet()) {
                    long cd = Long.valueOf(entry.getValue());
                    hero.setCooldown(entry.getKey(), cd);
                }
            }
            if (trait.getExperience() != null) {
                for (Map.Entry entry : trait.getExperience().entrySet()) {
                    HeroClass hClass = this.plugin.getClassManager().getClass((String)entry.getKey());
                    double exp = Double.valueOf((String)entry.getValue());
                    hero.setExperience(hClass, exp);
                }
            }
            if (trait.getMastered() != null) {
                for (String string : trait.getMastered()) {
                    HeroClass hClass = this.plugin.getClassManager().getClass(string);
                    hero.setMastered(hClass);
                }
            }
        }
        catch (Exception e) {
            Heroes.log(Level.SEVERE, "Error loading Citizen NPC Hero");
            e.printStackTrace();
        }
        player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        hero.setMana(hero.getMaxMana());
        return hero;
    }

    @Override
    public void saveHero(Hero hero, boolean now) {
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)hero.getPlayer());
        if (!npc.hasTrait(HeroesNPCTrait.class)) {
            npc.addTrait(HeroesNPCTrait.class);
        }
        HeroesNPCTrait trait = (HeroesNPCTrait)npc.getTrait(HeroesNPCTrait.class);
        trait.setPrimaryClass(hero.getHeroClass());
        trait.setSecondaryClass(hero.getSecondaryClass());
        trait.setRaceClass(hero.getRaceClass());
        trait.setCooldowns(hero.getCooldowns());
        trait.setExperience(hero.getExperienceMap());
        trait.setMastered(hero.getMasteredClasses());
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void saveHeroXP(Hero hero, HeroClass hc) {
    }

    @Override
    public void saveHeroClass(Hero hero, HeroClass hc, boolean secondary, boolean race) {
    }

    @Override
    public void destroyHeroBind(Hero hero, Material material) {
    }

    @Override
    public void saveHeroBind(Hero hero, Material material, String[] skills) {
    }

    @Override
    public void clearHeroBinds(Hero hero) {
    }

    @Override
    public void saveHeroSkillSettings(Hero hero, String skillName, String node, Object val) {
    }

    @Override
    public void saveHeroAttribute(Hero hero, HeroClass heroClass, AttributeType attributeType, int value) {
    }

    @Override
    public void resetHeroAttribute(Hero hero) {
    }

    @Override
    public void saveHeroCooldown(Hero hero, String name, long cooldown) {
    }

    @Override
    public void clearHeroCooldowns(Hero hero) {
    }

    @Override
    public void removeHeroCooldown(Hero hero, String name) {
    }

    @Override
    public void saveHeroAllocationPoint(Hero hero, HeroClass heroClass, int value) {
    }

    @Override
    public void resetHeroAllocationPoint(Hero hero) {
    }

    @Override
    public void addHeroSuppressedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void removeHeroSuppressedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void addHeroLearnedSkill(HeroSkill heroSkill) {
    }

    @Override
    public void loadHeroLearnedSkill(HeroSkill heroSkill) {
    }

    @Override
    public void removeHeroLearnedSkill(HeroSkill heroSkill) {
    }

    @Override
    public void addHeroPreparedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void removeHeroPreparedSkill(Hero hero, Skill skill) {
    }

    @Override
    public void resetHeroExperience(Hero hero) {
    }

    @Override
    public void resetHeroMasteries(Hero hero) {
    }

    @Override
    public void setHeroClassMastered(Hero hero, HeroClass heroClass) {
    }

    @Override
    public void setHeroVerboseExp(Hero hero, boolean value) {
    }

    @Override
    public void setHeroVerboseMana(Hero hero, boolean isVerbose) {
    }

    @Override
    public void setHeroVerboseStamina(Hero hero, boolean isVerbose) {
    }

    @Override
    public void setHeroVerboseSkills(Hero hero, boolean isVerbose) {
    }

    @Override
    public void createHero(Hero hero) {
    }

    @Override
    public void updatePlayerMetadata(String playerName, UUID uuid, InetAddress address) {
    }

    @Override
    public int getHeroID(UUID uuid) {
        return 0;
    }

    @Override
    public Hero loadLegacyHero(Player player) {
        return null;
    }
}

