/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.integrations.citizens;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.CombatEffect;
import com.herocraftonline.heroes.characters.effects.common.InvisibleEffect;
import com.herocraftonline.heroes.command.Command;
import java.util.UUID;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CitizensNPCListener
implements Listener {
    Heroes plugin;

    public CitizensNPCListener(Heroes plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCDeath(NPCDeathEvent event) {
        if (event.getNPC().getEntity() instanceof Player) {
            CharacterManager cM = this.plugin.getCharacterManager();
            Hero hero = cM.getHero((Player)event.getNPC().getEntity());
            hero.cancelDelayedSkill();
            hero.silentClearEffects(false);
            hero.recheckCombat();
            if (hero.isInCombat()) {
                hero.leaveCombat(CombatEffect.LeaveCombatReason.LOGOUT);
            }
            cM.saveHero(hero, true);
            cM.removeHero(hero);
            cM.getHero((Player)event.getNPC().getEntity());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent event) {
        if (event.getNPC().getEntity() instanceof Player) {
            CharacterManager cM = this.plugin.getCharacterManager();
            Hero hero = cM.getHero((Player)event.getNPC().getEntity());
            Player player = hero.getPlayer();
            hero.cancelDelayedSkill();
            hero.silentClearEffects(false);
            hero.recheckCombat();
            if (hero.isInCombat()) {
                hero.leaveCombat(CombatEffect.LeaveCombatReason.LOGOUT);
            }
            cM.saveHero(hero, true);
            cM.removeHero(hero);
            this.plugin.getCommandHandler().getCommands().stream().filter(Command::isInteractive).forEach(command -> command.cancelInteraction((CommandSender)player));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent event) {
        if (event.getNPC().getEntity() instanceof Player) {
            final Hero hero = this.plugin.getCharacterManager().getHero((Player)event.getNPC().getEntity());
            Player player = hero.getPlayer();
            double currentHP = player.getHealth();
            double maxHP = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            hero.resetMaxHP();
            double ratio = currentHP / maxHP;
            if (ratio > 1.0) {
                ratio = 1.0;
            }
            player.setHealth(ratio * player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
            if (!hero.hasEffect("Combat")) {
                hero.resetCombatEffect();
            }
            hero.checkClasses();
            hero.syncExperience();
            hero.resolveCurrentEquipment();
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    CitizensNPCListener.this.plugin.getCharacterManager().performSkillChecks(hero);
                    hero.resolveCurrentEquipment();
                }
            }, 5L);
            if (!player.hasPermission("heroes.admin.seeinvis")) {
                for (UUID uid : InvisibleEffect.hiddenPlayers) {
                    player.hidePlayer(Bukkit.getPlayer((UUID)uid));
                }
            }
        }
    }
}

