/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.scoreboard;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.commands.SidebarCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class ScoreboardFeature
implements Listener {
    private final CharacterManager characterManager;
    private final Map<UUID, ManagedScoreboard> scoreboards = new HashMap<UUID, ManagedScoreboard>();

    public ScoreboardFeature(Heroes heroes) {
        this.characterManager = heroes.getCharacterManager();
        heroes.getCommandHandler().addCommand(new SidebarCommand(heroes));
    }

    public ManagedScoreboard getScoreboard(Player player) {
        return this.scoreboards.computeIfAbsent(player.getUniqueId(), key -> new ManagedScoreboard(player).setDisplayName(Heroes.properties.scoreboardTitle));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerKick(PlayerKickEvent event) {
        this.cleanup(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerQuit(PlayerQuitEvent event) {
        this.cleanup(event.getPlayer());
    }

    private void cleanup(Player player) {
        Hero hero = this.characterManager.getHero(player);
        ManagedScoreboard scoreboard = hero.getScoreboard();
        if (scoreboard != null) {
            scoreboard.stop();
            scoreboard.destroy();
        }
        this.scoreboards.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Hero hero = this.characterManager.getHero(player);
        ManagedScoreboard scoreboard = hero.getScoreboard();
        if (scoreboard != null) {
            scoreboard.clear();
        }
    }

    @EventHandler
    public void partyKick(HeroLeavePartyEvent event) {
        Hero hero = event.getHero();
        ManagedScoreboard scoreboard = hero.getScoreboard();
        if (!hero.isDisconnecting() && scoreboard != null) {
            scoreboard.start();
            scoreboard.render();
        }
    }
}

