/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.roll;

import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.feature.roll.ItemRollContext;
import com.herocraftonline.heroes.feature.roll.ItemRollEntry;
import com.herocraftonline.heroes.feature.roll.ItemRollManager;
import com.herocraftonline.heroes.feature.roll.ItemRollType;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import to.hc.common.bukkit.callback.Callback;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.util.NMSHacks;

public class ItemRollMessageBuilder {
    protected static BaseComponent[] getDropMessage(@Nonnull ItemStack stack, final ItemRollContext context, final ItemRollEntry entry, Hero viewer, String victimName) {
        if (viewer.itemRollType != null) {
            return ItemRollMessageBuilder.autoRoll(stack, context, entry, viewer, victimName);
        }
        ComponentBuilder builder = new ComponentBuilder("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append(stack.getItemMeta().getDisplayName()).color(ChatUtil.toBungee(NMSHacks.getItemStackRarityColor(stack))).event(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[]{new TextComponent(NMSHacks.getItemStackCompoundTagAsString(stack))})).append("]").color(ChatUtil.toBungee(ChatColor.WHITE));
        if (ItemRollManager.get().includeVictimName) {
            builder.append(" has dropped from ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append(ChatColor.translateAlternateColorCodes((char)'&', (String)victimName)).color(ChatUtil.toBungee(ChatColor.GRAY)).append("]").color(ChatUtil.toBungee(ChatColor.WHITE));
        } else {
            builder.append(" has dropped").color(ChatUtil.toBungee(ChatColor.GRAY));
        }
        builder.append("!").color(ChatUtil.toBungee(ChatColor.GRAY)).append(" ").append("[").color(ChatUtil.toBungee(ChatColor.WHITE));
        if (context.singlePlayer) {
            ItemRollType.NEED.display(builder, true);
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("I'll take this item!").create()));
            ChatUtil.clickCallback(builder, new Callback(){

                @Override
                public void accept(CommandSender sender) {
                    entry.select((Player)sender, ItemRollType.NEED);
                    sender.sendMessage(ChatColor.GRAY + "You have selected " + ItemRollType.NEED.legacyDisplay(true) + ChatColor.GRAY + ".");
                    this.markUsed();
                }

                @Override
                protected void setUniqueId(@Nonnull UUID uniqueId) {
                    super.setUniqueId(uniqueId);
                    context.callbackIds.add(uniqueId);
                }
            });
            builder.append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" ").append("[").color(ChatUtil.toBungee(ChatColor.WHITE));
            ItemRollType.PASS.display(builder, true);
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("I have no use for this item.").create()));
            ChatUtil.clickCallback(builder, new Callback(){

                @Override
                public void accept(CommandSender sender) {
                    entry.select((Player)sender, ItemRollType.PASS);
                    sender.sendMessage(ChatColor.GRAY + "You have selected " + ItemRollType.PASS.legacyDisplay(true) + ChatColor.GRAY + ".");
                    this.markUsed();
                }

                @Override
                protected void setUniqueId(@Nonnull UUID uniqueId) {
                    super.setUniqueId(uniqueId);
                    context.callbackIds.add(uniqueId);
                }
            });
            builder.append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
        } else {
            ItemRollType.NEED.display(builder, false);
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("I really want this item!").create()));
            ChatUtil.clickCallback(builder, new Callback(){

                @Override
                public void accept(CommandSender sender) {
                    entry.select((Player)sender, ItemRollType.NEED);
                    sender.sendMessage(ChatColor.GRAY + "You have selected " + ItemRollType.NEED.legacyDisplay(false) + ChatColor.GRAY + ".");
                    this.markUsed();
                }

                @Override
                protected void setUniqueId(@Nonnull UUID uniqueId) {
                    super.setUniqueId(uniqueId);
                    context.callbackIds.add(uniqueId);
                }
            });
            builder.append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" ").append("[").color(ChatUtil.toBungee(ChatColor.WHITE));
            ItemRollType.GREED.display(builder, false);
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("I'd like to take this item to sell it.").create()));
            ChatUtil.clickCallback(builder, new Callback(){

                @Override
                public void accept(CommandSender sender) {
                    entry.select((Player)sender, ItemRollType.GREED);
                    sender.sendMessage(ChatColor.GRAY + "You have selected " + ItemRollType.GREED.legacyDisplay(false) + ChatColor.GRAY + ".");
                    this.markUsed();
                }

                @Override
                protected void setUniqueId(@Nonnull UUID uniqueId) {
                    super.setUniqueId(uniqueId);
                    context.callbackIds.add(uniqueId);
                }
            });
            builder.append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" ").append("[").color(ChatUtil.toBungee(ChatColor.WHITE));
            ItemRollType.PASS.display(builder, false);
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("I have no use for this item.").create()));
            ChatUtil.clickCallback(builder, new Callback(){

                @Override
                public void accept(CommandSender sender) {
                    entry.select((Player)sender, ItemRollType.PASS);
                    sender.sendMessage(ChatColor.GRAY + "You have selected " + ItemRollType.PASS.legacyDisplay(false) + ChatColor.GRAY + ".");
                    this.markUsed();
                }

                @Override
                protected void setUniqueId(@Nonnull UUID uniqueId) {
                    super.setUniqueId(uniqueId);
                    context.callbackIds.add(uniqueId);
                }
            });
            builder.append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
        }
        return builder.create();
    }

    private static BaseComponent[] autoRoll(@Nonnull ItemStack stack, ItemRollContext context, ItemRollEntry entry, Hero viewer, String victimName) {
        assert (viewer.itemRollType != null);
        entry.select(viewer.getPlayer(), viewer.itemRollType);
        ComponentBuilder builder = new ComponentBuilder("You have selected ").color(ChatUtil.toBungee(ChatColor.GRAY));
        viewer.itemRollType.display(builder, context.singlePlayer);
        return builder.append(" for ").color(ChatUtil.toBungee(ChatColor.GRAY)).append(stack.getItemMeta().getDisplayName()).color(ChatUtil.toBungee(NMSHacks.getItemStackRarityColor(stack))).event(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[]{new TextComponent(NMSHacks.getItemStackCompoundTagAsString(stack))})).append(".").color(ChatUtil.toBungee(ChatColor.GRAY)).create();
    }
}

