/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.roll;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.feature.roll.ItemRollCleanup;
import com.herocraftonline.heroes.feature.roll.ItemRollContext;
import com.herocraftonline.heroes.feature.roll.ItemRollMessageBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import to.hc.common.bukkit.util.NMSHacks;

public final class ItemRollManager
implements Listener {
    protected static final boolean DEBUG = false;
    protected static ItemRollManager self = new ItemRollManager();
    protected final int expireSeconds;
    protected final CharacterManager characterManager;
    protected final List<ItemRollCleanup> cleanups = Lists.newArrayList();
    protected final boolean includeVictimName;
    protected final double[] radius;

    public ItemRollManager() {
        this.expireSeconds = Heroes.properties.itemRollExpireSeconds;
        this.characterManager = Heroes.getInstance().getCharacterManager();
        this.includeVictimName = Heroes.properties.itemRollIncludeVictimName;
        this.radius = Heroes.properties.itemRollNearbyEntitiesRadius;
    }

    public static ItemRollManager get() {
        return self;
    }

    public void addCleanup(ItemRollCleanup cleanup) {
        this.cleanups.add(cleanup);
    }

    @EventHandler
    public void quit(PlayerQuitEvent event) {
        this.cleanups.forEach(entry -> entry.cleanup(event.getPlayer()));
    }

    protected List<Hero> getNearbyHeros(Player killerPlayer, Entity victim) {
        Hero killer = this.characterManager.getHero(killerPlayer);
        HeroParty party = killer.getParty();
        ArrayList result = Lists.newArrayList((Iterable)victim.getNearbyEntities(this.radius[0], this.radius[1], this.radius[2]).stream().filter(entity -> entity instanceof Player).map(entity -> this.characterManager.getHero((Player)entity)).filter(hero -> hero.getParty() != null && hero.getParty() == party).collect(Collectors.toList()));
        if (!result.contains(killer)) {
            result.add(killer);
        }
        return result;
    }

    protected void process(ItemRollContext context) {
        if (context.entries.isEmpty()) {
            return;
        }
        String expireMessage = ChatColor.YELLOW + (context.entries.size() == 1 ? "This drop" : "These drops") + " will expire in " + this.expireSeconds + " second" + (this.expireSeconds == 1 ? "" : "s") + ".";
        context.nearbyHeros.forEach(hero -> {
            Player player = hero.getPlayer();
            context.entries.forEach(entry -> NMSHacks.sendMessageAsMinecraft((CommandSender)player, ItemRollMessageBuilder.getDropMessage(entry.stack, context, entry, hero, entry.victimName)));
            player.sendMessage(expireMessage);
        });
        this.addCleanup(context.cleanup.init(this.expireSeconds));
    }

    protected boolean filterItemStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null || !meta.hasDisplayName() || meta.getDisplayName() == null || meta.getDisplayName().isEmpty()) {
            return false;
        }
        String colourName = ChatColor.translateAlternateColorCodes((char)'&', (String)meta.getDisplayName());
        String colourNameLower = colourName.toLowerCase();
        return (colourNameLower.length() <= 2 || colourNameLower.charAt(0) != '\u00a7' || colourNameLower.charAt(1) != 'f' && colourNameLower.charAt(1) != 'r') && colourName.contains(String.valueOf('\u00a7'));
    }
}

