/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.roll;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.herocraftonline.heroes.feature.roll.ItemRollContext;
import com.herocraftonline.heroes.feature.roll.ItemRollType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.util.NMSHacks;

final class ItemRollEntry {
    final Random random = new Random();
    final ItemRollContext context;
    final ItemStack stack;
    final Multimap<ItemRollType, Player> selections = HashMultimap.create();
    final String victimName;
    int selected;

    ItemRollEntry(ItemRollContext context, ItemStack stack, String victimName) {
        this.context = context;
        this.stack = stack.clone();
        if (this.stack.getAmount() < 1) {
            this.stack.setAmount(1);
        }
        this.victimName = victimName;
    }

    void select(Player player, ItemRollType type) {
        this.selections.put((Object)type, (Object)player);
        ++this.selected;
        if (this.context.nearbyHeros.size() == this.selected) {
            this.context.cleanup.skipProcess = true;
            this.process();
        }
    }

    void remove(Player player) {
        this.selections.remove((Object)ItemRollType.NEED, (Object)player);
        this.selections.remove((Object)ItemRollType.GREED, (Object)player);
        this.selections.remove((Object)ItemRollType.PASS, (Object)player);
    }

    void process() {
        if (!this.selections.isEmpty()) {
            ArrayList players;
            ItemRollType type;
            if (this.selections.containsKey((Object)ItemRollType.NEED)) {
                type = ItemRollType.NEED;
                players = Lists.newArrayList((Iterable)this.selections.get((Object)ItemRollType.NEED));
            } else {
                type = ItemRollType.GREED;
                players = Lists.newArrayList((Iterable)this.selections.get((Object)ItemRollType.GREED));
            }
            if (players.isEmpty()) {
                this.selections.clear();
                return;
            }
            Collections.shuffle(players);
            Player player = this.getPlayer(type, players);
            if (player != null && player.isOnline()) {
                this.giveItem(player);
            } else {
                player = this.getPlayer(type, players);
                if (player != null && player.isOnline()) {
                    this.giveItem(player);
                }
            }
            this.winnerWinnerChickenDinner(player);
            this.selections.clear();
        }
    }

    private void giveItem(Player player) {
        PlayerInventory inventory = player.getInventory();
        if (inventory.firstEmpty() != -1) {
            inventory.addItem(new ItemStack[]{this.stack});
        } else {
            player.getWorld().dropItemNaturally(player.getLocation().clone(), this.stack);
        }
    }

    private void winnerWinnerChickenDinner(Player player) {
        BaseComponent[] components = new ComponentBuilder(player.getName()).color(ChatUtil.toBungee(ChatColor.YELLOW)).append(" has won ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append(this.stack.getItemMeta().getDisplayName()).color(ChatUtil.toBungee(NMSHacks.getItemStackRarityColor(this.stack))).event(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new BaseComponent[]{new TextComponent(NMSHacks.getItemStackCompoundTagAsString(this.stack))})).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((HoverEvent)null).append(" in the roll!").color(ChatUtil.toBungee(ChatColor.GRAY)).create();
        this.selections.values().stream().filter(OfflinePlayer::isOnline).forEach(viewer -> NMSHacks.sendMessageAsMinecraft((CommandSender)viewer, components));
        NMSHacks.sendMessageAsMinecraft((CommandSender)player, components);
    }

    private Player getPlayer(ItemRollType type, List<Player> players) {
        Player player = players.get(this.random.nextInt(players.size()));
        this.selections.get((Object)type).remove(player);
        return player;
    }
}

