/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.roll;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.feature.roll.ItemRollContext;
import com.herocraftonline.heroes.feature.roll.ItemRollEntry;
import com.herocraftonline.heroes.feature.roll.ItemRollManager;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import to.hc.common.bukkit.callback.Callback;
import to.hc.common.bukkit.callback.CallbackRegistry;

public final class ItemRollCleanup
extends BukkitRunnable {
    private final ItemRollContext context;
    protected boolean skipProcess;

    public ItemRollCleanup(ItemRollContext context) {
        this.context = context;
    }

    protected ItemRollCleanup init(int after) {
        this.runTaskLater((Plugin)Heroes.getInstance(), after * 20);
        return this;
    }

    public void run() {
        this.context.callbackIds.forEach(uniqueId -> CallbackRegistry.get().get((UUID)uniqueId).ifPresent(Callback::markUsed));
        if (!this.skipProcess) {
            this.context.entries.forEach(ItemRollEntry::process);
        }
        this.context.nearbyHeros.clear();
        this.context.entries.forEach(entry -> entry.selections.clear());
        ItemRollManager.get().cleanups.remove((Object)this);
    }

    public void cleanup(Player player) {
        Iterator<Hero> it = this.context.nearbyHeros.iterator();
        while (it.hasNext()) {
            Hero hero = it.next();
            if (!hero.getPlayer().getDisplayName().equals(player.getName())) continue;
            it.remove();
        }
        this.context.entries.forEach(entry -> entry.remove(player));
    }
}

