/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.roll;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.feature.roll.ItemRollType;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HeroRollCommand
extends BasicCommand {
    private final Heroes heroes;

    public HeroRollCommand(Heroes heroes) {
        super("Hero Roll");
        this.heroes = heroes;
        this.setDescription("Set your rolling option");
        this.setUsage("/hero roll \u00a79<need|greed|pass|off>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero roll", "party roll");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.heroes.getCharacterManager().getHero(player);
        boolean party = hero.getParty() != null;
        try {
            hero.itemRollType = this.getType(args[0], party);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(e.getMessage());
        }
        if (hero.itemRollType != null) {
            sender.sendMessage(ChatColor.GRAY + "Your new roll option is " + ChatColor.GREEN + hero.itemRollType.name());
        } else {
            sender.sendMessage(ChatColor.GRAY + "Your roll option has been removed.");
        }
        return true;
    }

    private ItemRollType getType(String arg, boolean party) {
        if (arg.toLowerCase().equals("off")) {
            return null;
        }
        if (!party) {
            switch (arg.toLowerCase()) {
                case "take": 
                case "need": 
                case "greed": {
                    return ItemRollType.NEED;
                }
                case "discard": 
                case "pass": {
                    return ItemRollType.PASS;
                }
            }
        } else {
            switch (arg.toLowerCase()) {
                case "need": {
                    return ItemRollType.NEED;
                }
                case "greed": {
                    return ItemRollType.GREED;
                }
                case "pass": {
                    return ItemRollType.PASS;
                }
            }
        }
        throw new IllegalArgumentException("Unknown option '" + arg.toLowerCase() + "'");
    }
}

