/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.feature.roll;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.feature.roll.AbstractItemRoll;
import com.herocraftonline.heroes.feature.roll.ItemRollContext;
import com.herocraftonline.heroes.feature.roll.ItemRollEntry;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public final class BukkitItemRoll
extends AbstractItemRoll {
    @EventHandler(priority=EventPriority.LOWEST)
    public void entityDeath(EntityDeathEvent event) {
        LivingEntity victim = event.getEntity();
        if (victim instanceof Player) {
            return;
        }
        Player killer = victim.getKiller();
        ArrayList drops = Lists.newArrayList((Iterable)event.getDrops());
        if (killer != null && !drops.isEmpty()) {
            ItemRollContext context = new ItemRollContext(this.manager.getNearbyHeros(killer, (Entity)victim));
            String victimName = victim.getCustomName() != null ? victim.getCustomName() : victim.getType().getName();
            drops.stream().filter(this.manager::filterItemStack).forEach(stack -> {
                context.removalQueue.add((ItemStack)stack);
                context.entries.add(new ItemRollEntry(context, (ItemStack)stack, victimName));
            });
            event.getDrops().removeAll(context.removalQueue);
            this.manager.process(context);
        }
    }
}

