/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WhoisCommand
extends BasicCommand {
    private final Heroes plugin;

    public WhoisCommand(Heroes plugin) {
        super("Whois");
        this.plugin = plugin;
        this.setDescription("Checks for anyone with the given name");
        this.setUsage("/hero whois \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero whois");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Object classesString;
        Player searchedPlayer = this.plugin.getServer().getPlayer(args[0]);
        if (searchedPlayer != null) {
            if (sender instanceof Player && !((Player)sender).canSee(searchedPlayer)) {
                sender.sendMessage(ChatColor.RED + "That player is not online!");
                return false;
            }
            Hero hero = this.plugin.getCharacterManager().getHero(searchedPlayer);
            int level = Properties.getLevel(hero.getExperience(hero.getHeroClass()));
            HeroClass sClass = hero.getSecondaryClass();
            String secondClassName = sClass != null ? sClass.getName() : "";
            String secondLevelInfo = sClass != null ? "" + hero.getHeroLevel(sClass) : "";
            HeroClass rClass = hero.getRaceClass();
            String raceClassName = rClass != null ? rClass.getName() : "";
            String raceLevelInfo = rClass != null ? "" + hero.getHeroLevel(rClass) : "";
            classesString = "";
            if (rClass != null) {
                classesString = (String)classesString + "\u00a76" + raceClassName + ", ";
            }
            classesString = (String)classesString + "\u00a7aLevel " + level + " " + hero.getHeroClass().getName();
            if (sClass != null) {
                classesString = (String)classesString + ", \u00a7bLevel " + secondLevelInfo + " " + secondClassName;
            }
        } else {
            sender.sendMessage(ChatColor.RED + "That player is not online!");
            return false;
        }
        sender.sendMessage("\u00a7c-----[ \u00a7f" + searchedPlayer.getName() + "\u00a7c ]-----");
        sender.sendMessage((String)classesString);
        return true;
    }
}

