/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VerboseCommand
extends BasicCommand {
    private final Heroes plugin;

    public VerboseCommand(Heroes plugin) {
        super("Verbose");
        this.plugin = plugin;
        this.setDescription("Toggles the display of certain hero information.");
        this.setUsage("/hero verbose \u00a79<exp|mana|stamina|skills|all|info> [true|false]");
        this.setArgumentRange(1, 2);
        this.setIdentifiers("hero verbose");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        String type;
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        boolean toggle = true;
        boolean verbose = false;
        if (args.length > 1) {
            verbose = Boolean.parseBoolean(args[1]);
            toggle = false;
        }
        switch (type = args[0].toLowerCase()) {
            case "all": {
                this.setVerboseExp(player, hero, toggle ? !hero.isVerboseExp() : verbose);
                this.setVerboseMana(player, hero, toggle ? !hero.isVerboseMana() : verbose);
                this.setVerboseStamina(player, hero, toggle ? !hero.isVerboseStamina() : verbose);
                this.setVerboseSkills(player, hero, toggle ? !hero.isVerboseSkills() : verbose);
                break;
            }
            case "exp": {
                this.setVerboseExp(player, hero, toggle ? !hero.isVerboseExp() : verbose);
                break;
            }
            case "mana": {
                this.setVerboseMana(player, hero, toggle ? !hero.isVerboseMana() : verbose);
                break;
            }
            case "stamina": {
                this.setVerboseStamina(player, hero, toggle ? !hero.isVerboseStamina() : verbose);
                break;
            }
            case "skills": {
                this.setVerboseSkills(player, hero, toggle ? !hero.isVerboseSkills() : verbose);
                break;
            }
            case "info": {
                if (hero.isVerboseExp()) {
                    player.sendMessage(ChatColor.GRAY + "You are currently displaying exp gains.");
                } else {
                    player.sendMessage(ChatColor.GRAY + "You are not currently displaying exp gains.");
                }
                if (hero.isVerboseMana()) {
                    player.sendMessage(ChatColor.GRAY + "You are currently displaying mana gains.");
                } else {
                    player.sendMessage(ChatColor.GRAY + "You are not currently displaying mana gains.");
                }
                if (hero.isVerboseStamina()) {
                    player.sendMessage(ChatColor.GRAY + "You are currently displaying stamina gains.");
                } else {
                    player.sendMessage(ChatColor.GRAY + "You are not currently displaying stamina gains.");
                }
                if (hero.isVerboseSkills()) {
                    player.sendMessage(ChatColor.GRAY + "You are currently displaying skill messages.");
                    break;
                }
                player.sendMessage(ChatColor.GRAY + "You are not currently displaying skill messages.");
                break;
            }
            default: {
                player.sendMessage(ChatColor.RED + "Invalid parameter for verbose command. You need to provide one of the following, or no parameter at all. \u00a79<exp|mana|stamina|skills|all|info>");
            }
        }
        return true;
    }

    private void setVerboseExp(Player player, Hero hero, boolean verbose) {
        hero.setVerboseExp(verbose);
        if (hero.isVerboseExp()) {
            player.sendMessage(ChatColor.GRAY + "Now displaying exp gains.");
        } else {
            player.sendMessage(ChatColor.GRAY + "No longer displaying exp gains.");
        }
    }

    private void setVerboseMana(Player player, Hero hero, boolean verbose) {
        hero.setVerboseMana(verbose);
        if (hero.isVerboseMana()) {
            player.sendMessage(ChatColor.GRAY + "Now displaying mana gains.");
        } else {
            player.sendMessage(ChatColor.GRAY + "No longer displaying mana gains.");
        }
    }

    private void setVerboseStamina(Player player, Hero hero, boolean verbose) {
        hero.setVerboseStamina(verbose);
        if (hero.isVerboseStamina()) {
            player.sendMessage(ChatColor.GRAY + "Now displaying stamina gains.");
        } else {
            player.sendMessage(ChatColor.GRAY + "No longer displaying stamina gains.");
        }
    }

    private void setVerboseSkills(Player player, Hero hero, boolean verbose) {
        hero.setVerboseSkills(verbose);
        if (hero.isVerboseSkills()) {
            player.sendMessage(ChatColor.GRAY + "Now displaying skill messages.");
        } else {
            player.sendMessage(ChatColor.GRAY + "No longer displaying skill messages.");
        }
    }
}

