/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Util;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ToolsCommand
extends BasicCommand {
    private final Heroes plugin;

    public ToolsCommand(Heroes plugin) {
        super("Tools");
        this.plugin = plugin;
        this.setDescription("Displays tools available for your class");
        this.setUsage("/hero tools \u00a79[class]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero tools");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int i;
        HeroClass heroClass;
        if (!(sender instanceof Player)) {
            return false;
        }
        Set allTools = Arrays.stream(Material.values()).filter(x -> !x.name().startsWith("LEGACY_")).collect(Collectors.toSet());
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        boolean enforceClassCheck = false;
        HeroClass secondClass = null;
        HeroClass raceClass = null;
        if (args.length == 0) {
            heroClass = hero.getHeroClass();
            secondClass = hero.getSecondaryClass();
            raceClass = hero.getRaceClass();
        } else {
            heroClass = this.plugin.getClassManager().getClass(args[0]);
            enforceClassCheck = true;
            if (heroClass == null) {
                player.sendMessage(ChatColor.RED + "'" + args[0] + "' is not a valid class.");
                return false;
            }
        }
        String[] categories = new String[]{"Sword", "Shovel", "Pickaxe", "Axe", "Hoe", "Other"};
        String[] categorizedTools = new String[categories.length];
        for (int i2 = 0; i2 < categories.length; ++i2) {
            categorizedTools[i2] = "";
        }
        CharacterDamageManager damageManager = this.plugin.getDamageManager();
        block1: for (Material mat : allTools) {
            String tool = mat.name();
            for (int i3 = 0; i3 < categories.length; ++i3) {
                Double damage;
                if (tool.endsWith(categories[i3].toUpperCase())) {
                    if (categorizedTools[i3] == null) {
                        categorizedTools[i3] = "";
                    }
                    if (Util.isWeapon(mat) && (!enforceClassCheck ? !hero.isAllowedWeapon(heroClass, mat) && !hero.isAllowedWeapon(secondClass, mat) && !hero.isAllowedWeapon(raceClass, mat) : !hero.isAllowedWeapon(heroClass, mat))) continue block1;
                    damage = enforceClassCheck ? damageManager.getDefaultClassDamage(hero, heroClass, mat) : damageManager.getDefaultClassDamage(hero, mat);
                    String formattedDamage = Util.decFormat.format(damage);
                    int n = i3;
                    categorizedTools[n] = categorizedTools[n] + MaterialUtil.getFriendlyName(tool).split(" ")[0] + ": " + ChatColor.GRAY + formattedDamage + "\u00a7f, ";
                    continue block1;
                }
                if (!categories[i3].toUpperCase().equals("OTHER") || !tool.equals("BOW") && !tool.equals("TRIDENT") && !tool.equals("CROSSBOW") && !tool.equals("FLINT_AND_STEEL") && !tool.contains("AIR") && !Util.isAwkwardWeapon(mat)) continue;
                if (categorizedTools[i3] == null) {
                    categorizedTools[i3] = "";
                }
                if (!tool.equals("FLINT_AND_STEEL") && !tool.contains("AIR") && !Util.isAwkwardWeapon(mat) && (enforceClassCheck ? !hero.isAllowedWeapon(heroClass, mat) : !hero.isAllowedWeapon(heroClass, mat) && !hero.isAllowedWeapon(secondClass, mat) && !hero.isAllowedWeapon(raceClass, mat))) continue block1;
                Double secondaryDamage = null;
                if (tool.equals("BOW")) {
                    damage = enforceClassCheck ? damageManager.getHighestProjectileDamage(hero, heroClass, CharacterDamageManager.ProjectileType.ARROW) : damageManager.getHighestProjectileDamage(hero, CharacterDamageManager.ProjectileType.ARROW);
                } else if (tool.equals("TRIDENT")) {
                    if (enforceClassCheck) {
                        damage = damageManager.getDefaultClassDamage(hero, heroClass, mat);
                        secondaryDamage = damageManager.getHighestProjectileDamage(hero, heroClass, CharacterDamageManager.ProjectileType.TRIDENT);
                    } else {
                        damage = damageManager.getDefaultClassDamage(hero, mat);
                        secondaryDamage = damageManager.getHighestProjectileDamage(hero, CharacterDamageManager.ProjectileType.TRIDENT);
                    }
                } else if (tool.equals("CROSSBOW")) {
                    if (enforceClassCheck) {
                        damage = damageManager.getHighestProjectileDamage(hero, heroClass, CharacterDamageManager.ProjectileType.ARROW);
                        secondaryDamage = damageManager.getHighestProjectileDamage(hero, heroClass, CharacterDamageManager.ProjectileType.FIREWORK_ROCKET);
                    } else {
                        damage = damageManager.getHighestProjectileDamage(hero, CharacterDamageManager.ProjectileType.ARROW);
                        secondaryDamage = damageManager.getHighestProjectileDamage(hero, CharacterDamageManager.ProjectileType.FIREWORK_ROCKET);
                    }
                } else {
                    damage = enforceClassCheck ? damageManager.getDefaultClassDamage(hero, heroClass, mat) : damageManager.getDefaultClassDamage(hero, mat);
                }
                if (damage == null) {
                    damage = Util.getDefaultDamage(mat);
                }
                String formattedDamage = Util.decFormat.format(damage);
                if (tool.equals("AIR")) {
                    int n = i3;
                    categorizedTools[n] = categorizedTools[n] + "Fist: " + ChatColor.GRAY + formattedDamage + "\u00a7f, ";
                    continue block1;
                }
                if (tool.equals("TRIDENT")) {
                    if (secondaryDamage == null) {
                        secondaryDamage = 8.0;
                    }
                    int n = i3;
                    categorizedTools[n] = categorizedTools[n] + MaterialUtil.getFriendlyName(tool).replace("_", " ") + ": " + ChatColor.GRAY + formattedDamage + " \u00a7f(" + ChatColor.GRAY + Util.decFormat.format(secondaryDamage) + " \u00a7fTHROWN), ";
                    continue block1;
                }
                if (tool.equals("CROSSBOW")) {
                    if (secondaryDamage == null) {
                        secondaryDamage = 0.0;
                    }
                    int n = i3;
                    categorizedTools[n] = categorizedTools[n] + MaterialUtil.getFriendlyName(tool).replace("_", " ") + ": " + ChatColor.GRAY + formattedDamage + " \u00a7f(" + ChatColor.GRAY + Util.decFormat.format(secondaryDamage) + " \u00a7fFirework), ";
                    continue block1;
                }
                if (damage <= 1.0) continue block1;
                int n = i3;
                categorizedTools[n] = categorizedTools[n] + MaterialUtil.getFriendlyName(tool).replace("_", " ") + ": " + ChatColor.GRAY + formattedDamage + "\u00a7f, ";
                continue block1;
            }
        }
        for (i = 0; i < categories.length; ++i) {
            if (categorizedTools[i].isEmpty()) continue;
            categorizedTools[i] = categorizedTools[i].substring(0, categorizedTools[i].length() - 2);
        }
        sender.sendMessage("\u00a7c--------[ \u00a7fAllowed Tools\u00a7c ]--------");
        for (i = 0; i < categories.length; ++i) {
            player.sendMessage("  \u00a7a" + categories[i] + ": \u00a7f" + categorizedTools[i]);
        }
        return true;
    }
}

