/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SuppressCommand
extends BasicCommand {
    private final Heroes plugin;

    public SuppressCommand(Heroes plugin) {
        super("Suppress");
        this.plugin = plugin;
        this.setDescription("Toggles the suppression of skill messages");
        this.setUsage("/hero stfu \u00a79<skill>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero stfu", "hero suppress");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (args.length == 0) {
            Set<String> suppressions = hero.getSuppressedSkills();
            if (suppressions.isEmpty()) {
                player.sendMessage(ChatColor.GRAY + "No skills suppressed.");
                return false;
            }
            StringBuilder list = new StringBuilder("Suppressing ");
            for (String skill : suppressions) {
                list.append(skill).append(", ");
            }
            player.sendMessage(ChatColor.GRAY + list.substring(0, list.length() - 2));
        } else {
            Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
            if (skill == null) {
                player.sendMessage(ChatColor.RED + "Skill not found.");
                return false;
            }
            if (hero.isSuppressing(skill)) {
                hero.setSuppressed(skill, false);
                player.sendMessage(ChatColor.GRAY + "Messages from " + ChatColor.WHITE + skill.getName() + ChatColor.GRAY + " are no longer suppressed.");
            } else {
                hero.setSuppressed(skill, true);
                player.sendMessage(ChatColor.GRAY + "Messages from " + ChatColor.WHITE + skill.getName() + ChatColor.GRAY + " are now suppressed.");
            }
        }
        return true;
    }
}

