/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.attributes.AttributeSet;
import com.herocraftonline.heroes.attributes.AttributeType;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.logging.Level;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsInfoCommand
extends BasicCommand {
    private final Heroes plugin;
    private static String attributeInfoSeperator = ChatColor.GREEN + ", ";

    public StatsInfoCommand(Heroes plugin) {
        super("Statistic Information");
        this.plugin = plugin;
        this.setDescription("Displays hero statistic information");
        this.setUsage("/stats");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("hero stats", "stats");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        AttributeSet attributes = hero.getAttributes();
        if (attributes == null) {
            Heroes.log(Level.SEVERE, "Attributes are NULL for Hero: " + hero.getName() + ", with class: " + hero.getHeroClass() + ".");
            sender.sendMessage("There was an error when attempting to load your attribute statistics.");
            return false;
        }
        StatsInfoCommand.displayStatsInfo(sender, player, hero, attributes);
        return true;
    }

    public static void displayStatsInfo(CommandSender sender, Player player, Hero hero, AttributeSet attributes) {
        String header = ChatColor.RED + "-----[ " + ChatColor.WHITE + "Your Statistic Information" + ChatColor.RED + " ]-----";
        HeroClass hc = hero.getHeroClass();
        HeroClass secondaryClass = hero.getSecondaryClass();
        HeroClass raceClass = hero.getRaceClass();
        int exp = (int)hero.getExperience(hc);
        int level = Properties.getLevel(exp);
        int secondaryLevel = hero.getHeroLevel(secondaryClass);
        Object levelString = " ";
        if (raceClass != null) {
            levelString = (String)levelString + ChatColor.GREEN + raceClass.getName() + ChatColor.WHITE + ", ";
        }
        levelString = (String)levelString + ChatColor.GREEN + "Level " + level + " " + ChatColor.WHITE + hc.getName() + ", " + ChatColor.GREEN + "Level " + secondaryLevel + " " + ChatColor.WHITE + secondaryClass.getName();
        int hp = (int)player.getHealth();
        int maxHP = (int)player.getMaxHealth();
        int shield = (int)hero.getShield();
        int maxShield = hero.getMaxShield();
        double resistValue = hero.getMagicResistsValue();
        String formattedResistValue = Util.decFormat.format(100.0 * resistValue);
        String hpResistsHeader = ChatColor.GREEN + " HP: " + ChatColor.WHITE + hp + ChatColor.GREEN + "/" + ChatColor.WHITE + maxHP + "  | ";
        hpResistsHeader = hpResistsHeader + ChatColor.GREEN + " Shield: " + ChatColor.WHITE + shield + ChatColor.GREEN + "/" + ChatColor.WHITE + maxShield + " | ";
        hpResistsHeader = hpResistsHeader + ChatColor.GREEN + " Magic Resists: " + (resistValue < 0.0 ? ChatColor.RED : ChatColor.WHITE) + formattedResistValue + "%";
        int mana = hero.getMana();
        int maxMana = hero.getMaxMana();
        int stamina = hero.getStamina();
        int maxStamina = hero.getMaxStamina();
        String resourcesString = ChatColor.BLUE + " Mana: " + ChatColor.WHITE + mana + ChatColor.BLUE + "/" + ChatColor.WHITE + maxMana + "  | ";
        resourcesString = resourcesString + ChatColor.YELLOW + " Stamina: " + ChatColor.WHITE + stamina + ChatColor.YELLOW + "/" + ChatColor.WHITE + maxStamina;
        int shieldRegen = hero.getShieldRegen();
        int manaRegen = hero.getManaRegen();
        int staminaRegen = hero.getStaminaRegen();
        String regenerationString = ChatColor.GREEN + " Shield Regen: " + ChatColor.WHITE + shieldRegen + " | ";
        regenerationString = regenerationString + ChatColor.BLUE + " Mana Regen: " + ChatColor.WHITE + manaRegen + "  | ";
        regenerationString = regenerationString + ChatColor.YELLOW + " Stamina Regen: " + ChatColor.WHITE + staminaRegen;
        double currentEquipmentWeight = hero.getCurrentEquipmentWeight();
        double maxEquipmentWeight = hero.getMaxEquipmentWeight();
        String currentEquipmentWeightString = ChatColor.GOLD + " Equipment Weight: " + ChatColor.WHITE + Util.decFormat.format(currentEquipmentWeight) + ChatColor.WHITE + "/" + Util.decFormat.format(maxEquipmentWeight);
        String movementSpeedHeader = ChatColor.GOLD + " Movement Speed: " + ChatColor.WHITE + Util.decFormat.format(hero.getMovementSpeed()) + "%";
        Object attributeString = ChatColor.GREEN + " Total Attributes:\n";
        attributeString = StatsInfoCommand.buildAttributeString(attributes, (String)attributeString);
        int allocationPoints = hero.getAllocationPoints();
        String allocationPointsString = ChatColor.GREEN + " Attribute Allocation Points: " + (allocationPoints < 1 ? ChatColor.GRAY : ChatColor.WHITE) + allocationPoints;
        sender.sendMessage(header);
        sender.sendMessage((String)levelString);
        sender.sendMessage(hpResistsHeader);
        sender.sendMessage(resourcesString);
        sender.sendMessage(regenerationString);
        sender.sendMessage(movementSpeedHeader);
        if (Heroes.properties.checkEquipmentWeight) {
            sender.sendMessage(currentEquipmentWeightString);
        }
        if (!attributes.hasAny() && allocationPoints < 1) {
            return;
        }
        sender.sendMessage((String)attributeString);
        sender.sendMessage(allocationPointsString);
    }

    private static String buildAttributeString(AttributeSet attributes, String attributeString) {
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.STRENGTH) + attributeInfoSeperator;
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.CONSTITUTION) + attributeInfoSeperator;
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.ENDURANCE) + attributeInfoSeperator;
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.DEXTERITY) + attributeInfoSeperator;
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.INTELLECT) + attributeInfoSeperator;
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.WISDOM) + attributeInfoSeperator;
        attributeString = (String)attributeString + StatsInfoCommand.getAttributeString(attributes, AttributeType.CHARISMA);
        return attributeString;
    }

    private static String getAttributeString(AttributeSet attributes, AttributeType type) {
        int attributeValue = attributes.getAttributeValue(type);
        return ChatColor.WHITE + WordUtils.capitalizeFully((String)type.toString()) + ": " + (attributeValue < 0 ? ChatColor.RED : ChatColor.GRAY) + attributeValue;
    }
}

