/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpecsCommand
extends BasicCommand {
    private static final int SPECS_PER_PAGE = 8;
    private final Heroes plugin;

    public SpecsCommand(Heroes plugin) {
        super("Specializations");
        this.plugin = plugin;
        this.setDescription("Lists all specializations available to your path");
        this.setUsage("/hero specs [primary|profession|class] \u00a78[page#]");
        this.setArgumentRange(0, 2);
        this.setIdentifiers("hero specs");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
        HashSet<HeroClass> childClasses = new HashSet<HeroClass>();
        int page = 0;
        Object classNames = "";
        if (args.length == 0) {
            childClasses.addAll(hero.getHeroClass().getSpecializations());
            if (hero.getSecondaryClass() != null) {
                childClasses.addAll(hero.getSecondaryClass().getSpecializations());
                classNames = hero.getHeroClass().getName() + " and " + hero.getSecondaryClass().getName();
            } else {
                classNames = hero.getHeroClass().getName();
            }
        } else if (args.length == 1) {
            try {
                page = Integer.parseInt(args[0]) - 1;
            }
            catch (NumberFormatException ignored) {
                if (args[0].toLowerCase().contains("pri")) {
                    childClasses.addAll(hero.getHeroClass().getSpecializations());
                    classNames = hero.getHeroClass().getName();
                }
                if (args[0].toLowerCase().contains("prof")) {
                    if (hero.getSecondaryClass() != null) {
                        childClasses.addAll(hero.getSecondaryClass().getSpecializations());
                        classNames = hero.getSecondaryClass().getName();
                    }
                    sender.sendMessage(ChatColor.RED + "You don't have a profession!");
                    return false;
                }
                HeroClass hc = this.plugin.getClassManager().getClass(args[0]);
                if (hc != null) {
                    childClasses.addAll(hc.getSpecializations());
                }
                sender.sendMessage(ChatColor.RED + this.getUsage());
                return false;
            }
        } else if (args.length == 2) {
            try {
                page = Integer.parseInt(args[1]) - 1;
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            if (args[0].toLowerCase().contains("pri")) {
                childClasses.addAll(hero.getHeroClass().getSpecializations());
                classNames = hero.getHeroClass().getName();
            } else if (args[0].toLowerCase().contains("prof")) {
                if (hero.getSecondaryClass() != null) {
                    childClasses.addAll(hero.getSecondaryClass().getSpecializations());
                    classNames = hero.getSecondaryClass().getName();
                }
            } else {
                sender.sendMessage(ChatColor.RED + this.getUsage());
                return false;
            }
        }
        HeroClass[] specs = childClasses.toArray(new HeroClass[childClasses.size()]);
        if (specs.length == 0) {
            sender.sendMessage(ChatColor.GRAY + "Your classes have no specializations.");
            return false;
        }
        int numPages = specs.length / 8;
        if (specs.length % 8 != 0) {
            ++numPages;
        }
        if (page >= numPages || page < 0) {
            page = 0;
        }
        sender.sendMessage("\u00a7c-----[ \u00a7f" + (String)classNames + " Specializations <" + (page + 1) + "/" + numPages + ">\u00a7c ]-----");
        int start = page * 8;
        int end = start + 8;
        if (end > specs.length) {
            end = specs.length;
        }
        for (int c = start; c < end; ++c) {
            HeroClass heroClass = specs[c];
            String description = heroClass.getDescription();
            if (description == null || description.isEmpty()) {
                sender.sendMessage("  \u00a7a" + heroClass.getName());
                continue;
            }
            sender.sendMessage("  \u00a7a" + heroClass.getName() + " - \u00a7f" + heroClass.getDescription());
        }
        sender.sendMessage("\u00a7cTo choose a specialization, type \u00a7f/hero choose <spec> \u00a7cor \u00a7f/hero prof <spec>");
        return true;
    }
}

