/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpawnParticleCommand
extends BasicCommand {
    private final Heroes plugin;
    private static final Particle[] particleTypes = Particle.values();
    private static final int PARTICLE_TYPES_PER_PAGE = 10;

    public SpawnParticleCommand(Heroes plugin) {
        super("SpawnParticleCommand");
        this.plugin = plugin;
        this.setDescription("Tests out spawning particle, with x,y,z relative to player. Use /hero spawnparticle help [page#] to view particle types.");
        this.setUsage("/hero spawnparticle \u00a79<particleType> <x> <y> <z> <particleCount> <xOffset> <yOffset> <zOffset> [extraData] [force extended distance render]");
        this.setArgumentRange(0, 10);
        this.setIdentifiers("hero spawnparticle");
        this.setPermission("heroes.admin.spawnparticle");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0 && args[0].toLowerCase().equals("help")) {
            int index = 0;
            if (args.length > 1) {
                int page = 0;
                try {
                    page = Integer.parseInt(args[1]) - 1;
                }
                catch (NumberFormatException e) {
                    player.sendMessage(ChatColor.RED + "Invalid help page number.");
                    return false;
                }
                if (page < 0) {
                    player.sendMessage(ChatColor.RED + "Invalid help page number.");
                    return false;
                }
                if (page * 10 < particleTypes.length) {
                    index = page * 10;
                } else {
                    player.sendMessage(ChatColor.RED + "Invalid help page number.");
                    return false;
                }
            }
            player.sendMessage(ChatColor.GRAY + "Particle types: " + this.getParticleTypeMessage(index));
            player.sendMessage(ChatColor.GRAY + "Use /hero spawnparticle help [page#] to view more particle types.");
        } else if (args.length > 7) {
            Particle particle;
            int particleType = 0;
            try {
                particleType = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException page) {
                // empty catch block
            }
            double x = 0.0;
            try {
                x = Double.parseDouble(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double y = 0.0;
            try {
                y = Double.parseDouble(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double z = 0.0;
            try {
                z = Double.parseDouble(args[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int particleCount = 1;
            try {
                particleCount = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double xOffset = 0.0;
            try {
                xOffset = Double.parseDouble(args[5]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double yOffset = 0.0;
            try {
                yOffset = Double.parseDouble(args[6]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double zOffset = 0.0;
            try {
                zOffset = Double.parseDouble(args[7]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double extraData = 0.0;
            if (args.length > 8) {
                try {
                    extraData = Double.parseDouble(args[8]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean forceRender = false;
            if (args.length == 10) {
                forceRender = Boolean.parseBoolean(args[9]);
            }
            World world = player.getWorld();
            if (0 <= particleType && particleType < particleTypes.length) {
                particle = particleTypes[particleType];
            } else {
                particle = particleTypes[0];
                player.sendMessage(ChatColor.RED + "Invalid particle type " + particleType + ". Using default: " + particleTypes[0].toString());
            }
            switch (particle) {
                case REDSTONE: {
                    world.spawnParticle(particle, player.getLocation().add(x, y, z), particleCount, xOffset, yOffset, zOffset, extraData, (Object)new Particle.DustOptions(Color.BLUE, 2.0f), forceRender);
                    break;
                }
                case BLOCK_DUST: {
                    world.spawnParticle(particle, player.getLocation().add(x, y + 1.0, z), particleCount, xOffset, yOffset, zOffset, extraData, (Object)world.getBlockAt(player.getLocation().add(x, y, z)).getBlockData(), forceRender);
                    break;
                }
                case BLOCK_CRACK: {
                    world.spawnParticle(particle, player.getLocation().add(x, y + 1.0, z), particleCount, xOffset, yOffset, zOffset, extraData, (Object)world.getBlockAt(player.getLocation().add(x, y, z)).getBlockData(), forceRender);
                    break;
                }
                default: {
                    try {
                        world.spawnParticle(particle, player.getLocation().add(x, y, z), particleCount, xOffset, yOffset, zOffset, extraData, null, forceRender);
                    }
                    catch (Exception e) {
                        player.sendMessage(ChatColor.RED + "Particle type " + particleTypes[particleType].toString() + " is not correctly handled. See log for more details.");
                        e.printStackTrace();
                    }
                    break;
                }
            }
        } else {
            player.sendMessage(ChatColor.GRAY + "Need at least 8 arguments for SpawnParticle.");
            player.sendMessage(ChatColor.GRAY + "Usage: " + this.getUsage());
            player.sendMessage(ChatColor.GRAY + "Player types: " + this.getParticleTypeMessage(0));
            player.sendMessage(ChatColor.GRAY + "Use /hero spawnparticle help [page#] to view more particle types.");
        }
        return true;
    }

    private String getParticleTypeMessage(int startingParticleIndex) {
        StringBuilder message = new StringBuilder(startingParticleIndex + ": " + particleTypes[startingParticleIndex]);
        for (int i = startingParticleIndex + 1; i < particleTypes.length && i < startingParticleIndex + 10; ++i) {
            message.append("; ").append(i).append(": ").append(particleTypes[i]);
        }
        return message.toString();
    }
}

