/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillUnprepareCommand
extends BasicCommand {
    private final Heroes plugin;

    public SkillUnprepareCommand(Heroes plugin) {
        super("SkillUnprepareCommand");
        this.plugin = plugin;
        this.setDescription("Unprepares a skill");
        this.setUsage("/hero skill unprepare \u00a79<skill>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero skill unprepare");
        this.setPermission("heroes.skill.unprepare");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "You must be a player to unprepare skills.");
            return true;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
        if (hero.isInCombat()) {
            sender.sendMessage(ChatColor.RED + "You can not unprepare skills in combat!");
            return true;
        }
        if (skill == null) {
            sender.sendMessage(ChatColor.RED + "The skill '" + ChatColor.WHITE + args[0] + ChatColor.RED + "' does not exist.");
            return true;
        }
        if (!hero.hasAccessToSkill(skill)) {
            sender.sendMessage(ChatColor.RED + "None of your classes has the skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "`.");
            return true;
        }
        if (!hero.isSkillPrepared(skill)) {
            sender.sendMessage(ChatColor.RED + "The skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "` isn't prepared.");
            return true;
        }
        if (hero.unprepareSkill(skill)) {
            sender.sendMessage(ChatColor.AQUA + "You have unprepared the skill " + ChatColor.DARK_AQUA + skill.getName() + ChatColor.AQUA + " freeing up " + ChatColor.YELLOW + hero.getSkillPrepareCost(skill).getAsInt() + ChatColor.AQUA + " skill points giving you " + ChatColor.YELLOW + hero.getRemainingSkillPreparePoints() + ChatColor.AQUA + " now to spend.");
        } else {
            sender.sendMessage(ChatColor.RED + "The skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "` failed to unprepare, this us unintended and may be a bug, please let staff know.");
        }
        return true;
    }
}

