/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillPrepareCommand
extends BasicCommand {
    private final Heroes plugin;

    public SkillPrepareCommand(Heroes plugin) {
        super("SkillPrepareCommand");
        this.plugin = plugin;
        this.setDescription("Prepares a skill");
        this.setUsage("/hero skill prepare \u00a79<skill>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("hero skill prepare");
        this.setPermission("heroes.skill.prepare");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "You must be a player to prepare skills.");
            return true;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
        if (hero.isInCombat()) {
            sender.sendMessage(ChatColor.RED + "You can not prepare skills in combat!");
            return true;
        }
        if (skill == null) {
            sender.sendMessage(ChatColor.RED + "The skill '" + ChatColor.WHITE + args[0] + ChatColor.RED + "' does not exist.");
            return true;
        }
        if (!hero.hasAccessToSkill(skill)) {
            sender.sendMessage(ChatColor.RED + "None of your classes has the skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "`.");
            return true;
        }
        HeroSkill primary = hero.getHeroSkillForPrimary(skill);
        HeroSkill secondary = hero.getHeroSkillForSecondary(skill);
        HeroSkill race = hero.getHeroSkillForRace(skill);
        HeroSkill global = hero.getHeroSkillForGlobal(skill);
        if (!(primary != null && primary.getClassSkill().preparedUse() || secondary != null && secondary.getClassSkill().preparedUse() || race != null && race.getClassSkill().preparedUse() || global != null && global.getClassSkill().preparedUse())) {
            sender.sendMessage(ChatColor.RED + "The skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "` does not need to be prepared.");
            return true;
        }
        if (hero.isSkillPrepared(skill)) {
            sender.sendMessage(ChatColor.RED + "You already have the skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "` prepared.");
            return true;
        }
        if (!hero.canUseSkill(skill, true, true)) {
            sender.sendMessage(ChatColor.RED + "You are not high enough level to prepare the skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "`.");
            return true;
        }
        if (!hero.canUseSkill(skill, true, false, true)) {
            sender.sendMessage(ChatColor.RED + "You have not learned how to prepare the skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "`.");
            return true;
        }
        if (hero.getPreparedSkillCount() >= hero.getPreparedSkillLimit()) {
            sender.sendMessage(ChatColor.RED + "You can not prepare any more skills, you have reached your maximum of `" + ChatColor.WHITE + hero.getPreparedSkillLimit() + ChatColor.RED + "`.");
            return true;
        }
        int prepareCost = hero.getSkillPrepareCost(skill).getAsInt();
        if (!hero.hasSkillPreparePointsRemaining(prepareCost)) {
            sender.sendMessage(ChatColor.RED + "You require `" + ChatColor.WHITE + prepareCost + ChatColor.RED + "` skill points in order to prepare the skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "`, you only have `" + ChatColor.WHITE + hero.getRemainingSkillPreparePoints() + ChatColor.RED + "` remaining.");
            return true;
        }
        if (hero.prepareSkill(skill)) {
            sender.sendMessage(ChatColor.DARK_GREEN + "You have prepared the skill " + ChatColor.DARK_AQUA + skill.getName() + ChatColor.DARK_GREEN + " spending " + ChatColor.YELLOW + prepareCost + ChatColor.DARK_GREEN + "` skill points, you have " + ChatColor.YELLOW + hero.getRemainingSkillPreparePoints() + ChatColor.DARK_GREEN + "` remaining.");
        } else {
            sender.sendMessage(ChatColor.RED + "The skill `" + ChatColor.WHITE + skill.getName() + ChatColor.RED + "` failed to prepare, this us unintended and may be a bug, please let staff know.");
        }
        return true;
    }
}

