/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.google.common.collect.Lists;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.ClassSkill;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.HeroSkill;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillListInfo;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.pagination.PaginatedResult;

public class SkillListCommand
extends BasicCommand {
    private static final String INFO_COMPONENT = ChatColor.GRAY + "For more information about a skill, hover over the name.";
    private static final String INFO_FALLBACK = ChatColor.GRAY + "To use a skill, type " + ChatColor.GREEN + "/skill <name>" + ChatColor.GRAY + ".For info type " + ChatColor.GREEN + "/skill <name> ?" + ChatColor.GRAY + ".";
    private final Heroes plugin;

    public SkillListCommand(Heroes plugin) {
        super("List Skills");
        this.plugin = plugin;
        this.setDescription("Displays a list of your class skills");
        this.setUsage("/skills \u00a78<prim|prof|race|global|heroclass> [page#]");
        this.setArgumentRange(0, 2);
        this.setIdentifiers("skills", "hero skills");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int level;
        Skill skill;
        String title;
        HeroClass hc;
        boolean global;
        boolean rac;
        boolean sec;
        boolean prim;
        int page;
        HeroClass raceClass;
        HeroClass secondClass;
        HeroClass heroClass;
        Hero hero;
        block29: {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player = (Player)sender;
            hero = this.plugin.getCharacterManager().getHero(player);
            heroClass = hero.getHeroClass();
            secondClass = hero.getSecondaryClass();
            raceClass = hero.getRaceClass();
            page = 1;
            prim = true;
            sec = true;
            rac = true;
            global = true;
            hc = null;
            title = "Your";
            if (args.length != 0) {
                try {
                    page = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    if (args[0].toLowerCase().contains("prim")) {
                        sec = false;
                        rac = false;
                        global = false;
                        title = heroClass.getName();
                    } else if (args[0].toLowerCase().contains("pro")) {
                        prim = false;
                        rac = false;
                        global = false;
                        if (secondClass == null) {
                            sender.sendMessage(ChatColor.GRAY + "You don't have a secondary class!");
                            return true;
                        }
                        title = secondClass.getName();
                    } else if (args[0].toLowerCase().contains("race")) {
                        prim = false;
                        sec = false;
                        global = false;
                        if (raceClass == null) {
                            sender.sendMessage(ChatColor.GRAY + "You don't have a race!");
                            return true;
                        }
                        title = raceClass.getName();
                    } else if (args[0].toLowerCase().contains("global")) {
                        prim = false;
                        sec = false;
                        if (!HeroClass.hasGlobalSkillset()) {
                            sender.sendMessage(ChatColor.GRAY + "There is no global skill set!");
                            return true;
                        }
                    } else {
                        hc = this.plugin.getClassManager().getClass(args[0]);
                        if (hc != null) {
                            prim = false;
                            sec = false;
                            rac = true;
                            global = false;
                            title = hc.getName();
                        } else {
                            sender.sendMessage(ChatColor.GRAY + "That class does not exist!");
                            return true;
                        }
                    }
                    if (args.length <= 1) break block29;
                    try {
                        page = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        HashMap<SkillListInfo, Integer> skills = new HashMap<SkillListInfo, Integer>();
        if (prim) {
            for (String name : heroClass.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(heroClass, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(heroClass, skill), level);
            }
        }
        if (sec && secondClass != null) {
            for (String name : secondClass.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(secondClass, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(secondClass, skill), level);
            }
        }
        if (rac && raceClass != null) {
            for (String name : raceClass.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(raceClass, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(raceClass, skill), level);
            }
        }
        if (global && HeroClass.hasGlobalSkillset()) {
            for (String name : HeroClass.getGlobalSkillset().getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(HeroClass.getGlobalSkillset(), skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(HeroClass.getGlobalSkillset(), skill), level);
            }
        }
        if (hc != null) {
            for (String name : hc.getSkillNames()) {
                skill = this.plugin.getSkillManager().getSkill(name);
                level = SkillConfigManager.getSetting(hc, skill, SkillSetting.LEVEL.node(), 1);
                skills.put(new SkillListInfo(hc, skill), level);
            }
        }
        final boolean isTainted = !prim || !sec;
        final String arg0 = args.length >= 1 ? args[0] : "";
        new PaginatedResult<Map.Entry<SkillListInfo, Integer>>(ChatColor.DARK_AQUA + title + " Skills", "/hero skills {PART} {INDEX}"){

            @Override
            protected BaseComponent[] build(Map.Entry<SkillListInfo, Integer> entry, int index) {
                SkillListInfo info = entry.getKey();
                int level = entry.getValue();
                Skill skill = info.getSkill();
                HeroClass hc = info.getHeroClass();
                ClassSkill classSkill = hc.getClassSkill(skill);
                HeroSkill heroSkill = hero.getHeroSkill(classSkill);
                int currentLevel = hero.getHeroLevel(hc);
                boolean isPassive = skill instanceof PassiveSkill || skill instanceof OutsourcedSkill;
                boolean isLearned = heroSkill.isLearned();
                boolean isPrepared = hero.isSkillPrepared(skill);
                boolean higherLevelRequired = level > currentLevel;
                boolean learningRequired = classSkill.learnedUse() && !isLearned;
                boolean preparationRequired = classSkill.preparedUse() && !isPrepared;
                ComponentBuilder builder = new ComponentBuilder("   [").color(ChatUtil.toBungee(ChatColor.WHITE)).append("?").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.createDescription(skill, hc, level, currentLevel, true, higherLevelRequired, learningRequired, preparationRequired))).append("] ").event((ClickEvent)null).event((HoverEvent)null).color(ChatUtil.toBungee(ChatColor.WHITE));
                builder.append(skill.getName());
                if (higherLevelRequired || learningRequired || preparationRequired) {
                    builder.color(ChatUtil.toBungee(ChatColor.RED));
                } else if (isPassive) {
                    builder.color(ChatUtil.toBungee(ChatColor.GREEN));
                } else if (skill.getMinArguments() > 0) {
                    builder.color(ChatUtil.toBungee(ChatColor.GREEN)).event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/skill " + skill.getName() + " "));
                } else {
                    builder.color(ChatUtil.toBungee(ChatColor.GREEN)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/skill " + skill.getName()));
                }
                builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.createDescription(skill, hc, level, currentLevel, false, higherLevelRequired, learningRequired, preparationRequired)));
                if (skill.hasShortDescription()) {
                    builder.append(": ").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(skill.getShortDescription()).color(ChatUtil.toBungee(ChatColor.GRAY));
                }
                return builder.create();
            }

            private BaseComponent[] createDescription(Skill skill, HeroClass hc, int level, int currentLevel, boolean infoBubble, boolean higherLevelRequired, boolean learningRequired, boolean preparationRequired) {
                if (infoBubble) {
                    return this.wrapDescription(skill.getDescription(hero) + skill.getDescriptionMetadata(hero));
                }
                ComponentBuilder builder = higherLevelRequired ? new ComponentBuilder("You must be a level ").color(ChatUtil.toBungee(ChatColor.YELLOW)).append(String.valueOf(level)).color(ChatUtil.toBungee(ChatColor.GRAY)).bold(true).append(" ").color(ChatUtil.toBungee(ChatColor.YELLOW)).bold(false).append(hc.getName()).color(ChatUtil.toBungee(ChatColor.LIGHT_PURPLE)).append(" to use this skill.").color(ChatUtil.toBungee(ChatColor.YELLOW)).append("\n").append("Progress: ").color(ChatUtil.toBungee(ChatColor.GRAY)).append(ChatComponents.Bars.skillProgress3(currentLevel, level)) : (skill instanceof PassiveSkill || skill instanceof OutsourcedSkill ? new ComponentBuilder("This skill is passive and cannot be used.").color(ChatUtil.toBungee(ChatColor.RED)) : (learningRequired ? new ComponentBuilder("You must learn the skill for ").color(ChatUtil.toBungee(ChatColor.YELLOW)).append(hc.getName()).color(ChatUtil.toBungee(ChatColor.LIGHT_PURPLE)).append(" to use this skill.").color(ChatUtil.toBungee(ChatColor.YELLOW)) : (preparationRequired ? new ComponentBuilder("You must prepare the skill to use the skill").color(ChatUtil.toBungee(ChatColor.YELLOW)) : (skill.getMinArguments() > 0 ? new ComponentBuilder("\u00bb  This skill requires " + skill.getMinArguments() + " arguments.  \u00ab").color(ChatUtil.toBungee(ChatColor.YELLOW)).append("\n").append("Click to pre-fill the command in your chat bar.").color(ChatUtil.toBungee(ChatColor.GRAY)) : new ComponentBuilder("\u00bb  Click to use  \u00ab").color(ChatUtil.toBungee(ChatColor.GREEN))))));
                return builder.create();
            }

            private BaseComponent[] wrapDescription(String description) {
                ComponentBuilder builder = new ComponentBuilder(description);
                boolean first = true;
                for (String line : this.wordWrap(description, 60, "", Lists.newArrayList())) {
                    if (first) {
                        first = false;
                        builder = new ComponentBuilder(line);
                        continue;
                    }
                    builder.append("\n").append(line);
                }
                return builder.create();
            }

            @Override
            protected String buildFallback(Map.Entry<SkillListInfo, Integer> entry, int index) {
                HeroClass hc;
                SkillListInfo sli = entry.getKey();
                int level = entry.getValue();
                ChatColor color = level > hero.getHeroLevel(hc = sli.getHeroClass()) ? ChatColor.RED : ChatColor.GREEN;
                return "  " + color + " " + hc.getName().substring(0, 3 > hc.getName().length() ? hc.getName().length() : 3) + " " + level + " " + ChatColor.YELLOW + sli.getSkill().getName() + ": " + ChatColor.GOLD + sli.getSkill().getDescription(hero) + sli.getSkill().getDescriptionMetadata(hero);
            }

            @Override
            protected void after(CommandSender viewer, ChatSendResult chatSendResult) {
                if (chatSendResult == ChatSendResult.FALLBACK) {
                    viewer.sendMessage(INFO_FALLBACK);
                } else {
                    viewer.sendMessage(INFO_COMPONENT);
                }
            }

            @Override
            public String buildPageCommand(int page) {
                return this.pageCommand.replace("{PART}", isTainted ? arg0 : "").replace("{INDEX}", String.valueOf(page));
            }

            public List<String> wordWrap(String line, int maxLen, String lastColor, List<String> list) {
                int length;
                int n = length = StringUtils.isEmpty((String)line) ? 0 : line.length();
                if (length <= maxLen) {
                    list.add(lastColor + line);
                    return list;
                }
                boolean space = false;
                int cutOff = maxLen;
                for (int offSet = 0; offSet < maxLen; ++offSet) {
                    if (!Character.isWhitespace(line.charAt(maxLen - offSet))) continue;
                    cutOff = maxLen - offSet;
                    space = true;
                    break;
                }
                String addLine = line.substring(0, cutOff);
                list.add(lastColor + addLine);
                return this.wordWrap(line.substring(cutOff + (space ? 1 : 0)), maxLen, ChatColor.getLastColors((String)addLine), list);
            }
        }.display(sender, Lists.newArrayList(SkillListInfo.entriesSortedByValues(skills)), page);
        return true;
    }
}

