/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.ui.HeroUIComponent;
import com.herocraftonline.heroes.ui.scoreboard.HeroInfoComponent;
import com.herocraftonline.heroes.ui.scoreboard.PartyComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.ui.ManagedScoreboard;

public class SidebarCommand
extends BasicCommand {
    private final Heroes plugin;

    public SidebarCommand(Heroes plugin) {
        super("Sidebar");
        this.plugin = plugin;
        this.setArgumentRange(1, 1);
        this.setUsage(ChatColor.DARK_GRAY + "/hero sidebar " + ChatColor.DARK_GRAY + "<" + ChatColor.GRAY + "none" + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + "all" + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + "info" + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + "party" + ChatColor.DARK_GRAY + ">");
        this.setDescription("Configure the sidebar");
        this.setIdentifiers("hero sidebar");
    }

    @Override
    public boolean execute(CommandSender executor, String identifier, String[] args) {
        if (!(executor instanceof Player)) {
            return false;
        }
        String arg = args[0].toLowerCase();
        ManagedScoreboard scoreboard = this.plugin.getCharacterManager().getHero((Player)executor).getScoreboard();
        if (scoreboard == null) {
            executor.sendMessage(ChatColor.RED + "Something went wrong and your missing a scoreboard!");
            return true;
        }
        switch (arg) {
            case "none": {
                scoreboard.clearComponents();
                scoreboard.clear();
                executor.sendMessage(ChatColor.GRAY + "Sidebar disabled.");
                return true;
            }
            case "all": {
                scoreboard.clearComponents();
                scoreboard.clear();
                for (HeroUIComponent.Scoreboard component : HeroUIComponent.Scoreboard.values()) {
                    scoreboard.addComponent(component.component());
                }
                break;
            }
            default: {
                block21: for (String value : arg.split(",")) {
                    switch (value.toLowerCase()) {
                        case "info": 
                        case "heroinfo": {
                            scoreboard.toggleComponent(HeroInfoComponent.SELF);
                            continue block21;
                        }
                        case "cooldown": 
                        case "cooldowns": {
                            executor.sendMessage(ChatColor.YELLOW + "Cooldowns are no longer a sidebar component.");
                            return true;
                        }
                        case "party": {
                            scoreboard.toggleComponent(PartyComponent.SELF);
                        }
                    }
                }
            }
        }
        executor.sendMessage(ChatColor.GRAY + "Changes applied!" + ChatColor.GREEN + " Active components" + ChatColor.WHITE + ": " + HeroUIComponent.Scoreboard.toString(scoreboard));
        scoreboard.start();
        scoreboard.render();
        return true;
    }
}

