/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShieldCommand
extends BasicCommand {
    private final Heroes plugin;

    public ShieldCommand(Heroes plugin) {
        super("Shield");
        this.plugin = plugin;
        this.setDescription("Displays your shield");
        this.setUsage("/shield");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("shield", "sh", "hero shield");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
        float shield = hero.getShield();
        int maxShield = hero.getMaxShield();
        sender.sendMessage(ChatComponents.Bars.shield(shield, maxShield, true));
        return true;
    }
}

