/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResetRaceCommand
extends BasicInteractiveCommand {
    Heroes plugin;
    private final Set<String> pendingResets = new HashSet<String>();

    public ResetRaceCommand(Heroes plugin) {
        super("Reset Race");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Resets your Race");
        this.setUsage("/hero resetrace");
        this.setPermission("heroes.resetrace");
    }

    @Override
    public String getCancelIdentifier() {
        return "hero cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingResets.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("hero resetrace");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Player player = (Player)executor;
            HeroClass defaultRace = ResetRaceCommand.this.plugin.getClassManager().getDefaultRace();
            String raceString = defaultRace != null ? defaultRace.getName() : "raceless";
            executor.sendMessage(ChatColor.YELLOW + "Your race will be reset to: " + ChatColor.WHITE + raceString);
            ChatComponents.ConfirmOrCancel.GENERIC.send(executor);
            ResetRaceCommand.this.pendingResets.add(player.getName());
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("hero confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Player player = (Player)executor;
            ResetRaceCommand.this.pendingResets.remove(player.getName());
            Hero hero = ResetRaceCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentRace = hero.getRaceClass();
            HeroClass defaultRace = ResetRaceCommand.this.plugin.getClassManager().getDefaultRace();
            ClassChangeEvent event = new ClassChangeEvent(hero, currentRace, defaultRace, 0.0, false, true);
            Bukkit.getPluginManager().callEvent((Event)event);
            hero.setHeroClass(defaultRace, false, true);
            ResetRaceCommand.this.plugin.getCharacterManager().performSkillChecks(hero);
            if (defaultRace != null) {
                player.sendMessage(ChatColor.GRAY + "You are reborn as a " + ChatColor.WHITE + defaultRace.getName() + ChatColor.GREEN + "!");
            } else {
                player.sendMessage(ChatColor.GRAY + "You are reborn raceless" + ChatColor.GREEN + "!");
            }
            ResetRaceCommand.this.plugin.getCharacterManager().saveHero(hero, false);
            AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, currentRace, defaultRace, 0.0, false, true);
            ResetRaceCommand.this.plugin.getServer().getPluginManager().callEvent((Event)afterEvent);
            if (afterEvent.isCancelled()) {
                ResetRaceCommand.this.cancelInteraction((CommandSender)player);
                return true;
            }
            return true;
        }
    }
}

