/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResetCommand
extends BasicInteractiveCommand {
    Heroes plugin;
    private final Set<String> pendingResets = new HashSet<String>();

    public ResetCommand(Heroes plugin) {
        super("Reset Class");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Resets your XP and path");
        this.setUsage("/hero reset");
        this.setPermission("heroes.reset");
    }

    @Override
    public String getCancelIdentifier() {
        return "hero cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingResets.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("hero reset");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Player player = (Player)executor;
            HeroClass defaultClass = ResetCommand.this.plugin.getClassManager().getDefaultClass();
            HeroClass defaultProf = ResetCommand.this.plugin.getClassManager().getDefaultProfession();
            executor.sendMessage(ChatColor.YELLOW + "This will reset all earned XP, both classes and reset your class to: " + ChatColor.WHITE + defaultClass.getName());
            executor.sendMessage(ChatColor.YELLOW + "Your profession will be reset to: " + ChatColor.WHITE + defaultProf.getName());
            ChatComponents.ConfirmOrCancel.GENERIC.send(executor);
            ResetCommand.this.pendingResets.add(player.getName());
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("hero confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Player player = (Player)executor;
            ResetCommand.this.pendingResets.remove(player.getName());
            Hero hero = ResetCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass defaultClass = ResetCommand.this.plugin.getClassManager().getDefaultClass();
            HeroClass defaultProf = ResetCommand.this.plugin.getClassManager().getDefaultProfession();
            HeroClass previousClass = hero.getHeroClass();
            hero.cancelDelayedSkill();
            hero.silentClearEffects(false);
            hero.clearSummons();
            hero.clearExperience();
            hero.clearMasteries();
            hero.clearAllClassAttributeAllocations();
            hero.clearAllClassAllocationPoints();
            hero.clearCooldowns();
            hero.clearBinds();
            hero.rebuildAttributes();
            ClassChangeEvent event = new ClassChangeEvent(hero, hero.getHeroClass(), defaultClass, 0.0, false, true);
            Bukkit.getPluginManager().callEvent((Event)event);
            hero.setHeroClass(defaultClass, false, false);
            hero.setHeroClass(defaultProf, true, false);
            hero.syncExperience();
            ResetCommand.this.plugin.getCharacterManager().performSkillChecks(hero);
            if (Heroes.properties.prefixClassName) {
                player.setDisplayName("[" + hero.getHeroClass().getName() + "]" + player.getName());
            }
            player.sendMessage(ChatColor.GRAY + "Welcome to the path of the " + ChatColor.WHITE + defaultClass.getName() + ChatColor.GRAY + "!");
            ResetCommand.this.plugin.getCharacterManager().saveHero(hero, false);
            AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, previousClass, defaultClass, 0.0, false, true);
            Bukkit.getPluginManager().callEvent((Event)afterEvent);
            return true;
        }
    }
}

