/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.CommandHandler;
import java.util.ArrayList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.pagination.PaginatedResult;

public class RacesCommand
extends BasicCommand {
    private static final String CHOOSE_COMPONENT = ChatColor.GRAY + "To choose a race, click on the " + ChatComponents.BUTTON_SELECT + ChatColor.GRAY + " button.";
    private static final String CHOOSE_FALLBACK = ChatColor.GRAY + "To choose a race, type " + ChatColor.GREEN + "/hero race <race>" + ChatColor.GRAY + ".";
    private final Heroes plugin;

    public RacesCommand(Heroes plugin) {
        super("Races");
        this.plugin = plugin;
        this.setDescription("Lists all races available to you!");
        this.setUsage("/hero races \u00a78[page#]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero races");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players may use this command.");
            return false;
        }
        int page = 1;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ignored) {
                sender.sendMessage(ChatColor.RED + "Please provide a valid page number.");
                return false;
            }
        }
        final Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
        ArrayList<HeroClass> races = new ArrayList<HeroClass>();
        for (HeroClass hc : this.plugin.getClassManager().getClasses()) {
            if (hc.getTier() != 1 || !hc.isDefault() && !CommandHandler.hasPermission(sender, "heroes.races." + hc.getName().toLowerCase()) || !hc.isRace()) continue;
            races.add(hc);
        }
        new PaginatedResult<HeroClass>(ChatColor.DARK_AQUA + "Hero Races", "/hero races {INDEX}"){

            @Override
            protected BaseComponent[] build(HeroClass entry, int index) {
                boolean heroHasRace;
                String name = entry.getName();
                ComponentBuilder builder = new ComponentBuilder("  ");
                boolean bl = heroHasRace = hero.getRaceClass() != null && hero.getRaceClass() == entry;
                if (heroHasRace) {
                    builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Select").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("This is already your ").color(ChatUtil.toBungee(ChatColor.YELLOW)).append("race").color(ChatUtil.toBungee(ChatColor.YELLOW)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
                } else if (entry.isRace()) {
                    if (entry.isPrimary()) {
                        Heroes.getInstance().getLogger().warning("Class '" + name + "' is both primary and race.");
                    } else if (entry.isSecondary()) {
                        Heroes.getInstance().getLogger().warning("Class '" + name + "' is both secondary and race.");
                    }
                    builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Select").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hero race " + name)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Select Race").color(ChatUtil.toBungee(ChatColor.BLUE)).append(" - ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("/hero race " + name).color(ChatUtil.toBungee(ChatColor.GOLD)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
                }
                String description = entry.getDescription();
                builder.append("  ").append(name).color(ChatUtil.toBungee(ChatColor.GREEN)).append(" - ").color(ChatUtil.toBungee(ChatColor.WHITE));
                if (description != null && !description.isEmpty()) {
                    builder.append(description).color(ChatUtil.toBungee(ChatColor.GRAY));
                }
                return builder.create();
            }

            @Override
            protected String buildFallback(HeroClass entry, int index) {
                return RacesCommand.getLegacyText(entry, entry.getDescription());
            }

            @Override
            protected void after(CommandSender viewer, ChatSendResult chatSendResult) {
                if (chatSendResult == ChatSendResult.FALLBACK) {
                    viewer.sendMessage(CHOOSE_FALLBACK);
                } else {
                    viewer.sendMessage(CHOOSE_COMPONENT);
                }
            }
        }.display(sender, races, page);
        return true;
    }

    @Deprecated
    private static String getLegacyText(HeroClass clazz, String description) {
        String prefix = "";
        if (clazz.isRace()) {
            prefix = "  \u00a79Rac";
        }
        if (description != null && !description.isEmpty()) {
            return prefix + " | \u00a7a" + clazz.getName() + " - \u00a7f" + description;
        }
        return prefix + " | \u00a7a" + clazz.getName();
    }
}

