/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.util.Properties;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class RaceCommand
extends BasicInteractiveCommand {
    private final Heroes plugin;
    private final Map<String, HeroClass> pendingClassSelections = new HashMap<String, HeroClass>();
    private final Map<String, Double> pendingClassCostStatus = new HashMap<String, Double>();

    public RaceCommand(Heroes plugin) {
        super("Choose Race Class");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Select a race");
        this.setUsage("/hero race \u00a79<type>");
    }

    @Override
    public String getCancelIdentifier() {
        return "hero cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingClassSelections.remove(executor.getName());
        this.pendingClassCostStatus.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("hero rac", "hero race");
            this.setArgumentRange(1, 1);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Properties props = Heroes.properties;
            Player player = (Player)executor;
            Hero hero = RaceCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getRaceClass();
            HeroClass newClass = RaceCommand.this.plugin.getClassManager().getClass(args[0]);
            if (newClass == null) {
                executor.sendMessage(ChatColor.RED + "Race not found.");
                return false;
            }
            Long cooldown = hero.getCooldown("race-change");
            if (cooldown != null && cooldown > System.currentTimeMillis()) {
                player.sendMessage(ChatColor.RED + "You've changed race too recently. You must wait " + ChatColor.RED + (cooldown - System.currentTimeMillis()) / 1000L + ChatColor.GRAY + " seconds to change your class.");
                return false;
            }
            if (newClass.equals(currentClass) || newClass.equals(hero.getHeroClass())) {
                executor.sendMessage(ChatColor.RED + "You are already set as this Race.");
                return false;
            }
            if (!newClass.isRace()) {
                executor.sendMessage(ChatColor.RED + "That is not a race!");
                return false;
            }
            if (currentClass != null) {
                if (!currentClass.isDefaultRace() && hero.isMaster(currentClass) && currentClass.getParents().isEmpty() && props.lockAtHighestTier) {
                    executor.sendMessage(ChatColor.RED + "You have mastered your race and can not choose a new one!");
                    return false;
                }
                if (!hero.isMaster(currentClass) && props.lockPathTillMaster) {
                    executor.sendMessage(ChatColor.RED + "You must master this race before swapping to another.");
                    return false;
                }
            }
            if (!newClass.hasNoParents()) {
                for (HeroClass parentClass : newClass.getStrongParents()) {
                    if (hero.isMaster(parentClass)) continue;
                    executor.sendMessage(ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + " requires you to master one of: " + newClass.getStrongParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
                boolean masteredOne = false;
                for (HeroClass parentClass : newClass.getWeakParents()) {
                    if (!hero.isMaster(parentClass)) continue;
                    masteredOne = true;
                    break;
                }
                if (!masteredOne && !newClass.getWeakParents().isEmpty()) {
                    executor.sendMessage(ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + " requires you to master one of: " + newClass.getWeakParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
            }
            if (!newClass.isDefaultRace() && !CommandHandler.hasPermission((CommandSender)player, "heroes.races." + newClass.getName().toLowerCase())) {
                executor.sendMessage(ChatColor.GRAY + "You don't have permission for " + ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + ".");
                return false;
            }
            double cost = newClass.getCost();
            if ((currentClass == null || currentClass.equals(RaceCommand.this.plugin.getClassManager().getDefaultRace())) && Heroes.properties.firstSwitchFreeRace) {
                cost = 0.0;
            } else if (hero.getExperience(newClass) > 0.0) {
                cost = props.oldRaceSwapCost + props.oldRaceSwapCostPerLevel * (double)hero.getHeroLevel(newClass);
            }
            if (props.swapWithMasteriesHasFullCost && hero.getMasteredClasses().size() >= props.numberOfMasteriesForFullCost) {
                cost = props.oldRaceSwapCost + props.oldRaceSwapCostPerLevel * (double)newClass.getMaxLevel();
            }
            if (hero.isMaster(newClass) && props.swapMasterFree) {
                cost = 0.0;
            } else if (!props.economy || Heroes.econ == null || cost <= 0.0) {
                cost = 0.0;
            }
            if (props.economy && cost > 0.0 && !Heroes.econ.has((OfflinePlayer)player, cost)) {
                player.sendMessage(ChatColor.GRAY + "It will cost " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GRAY + " to switch races, you only have " + ChatColor.WHITE + Heroes.econ.getBalance((OfflinePlayer)player));
                return false;
            }
            RaceCommand.this.pendingClassCostStatus.put(player.getName(), cost);
            executor.sendMessage(" ");
            executor.sendMessage(ChatColor.GRAY + "You have chosen...");
            executor.sendMessage(ChatColor.GREEN + "\u00bb  " + ChatColor.BLUE + newClass.getName() + ChatColor.WHITE + ": " + ChatColor.GRAY + newClass.getDescription().toLowerCase());
            StringBuilder skills = new StringBuilder();
            for (String skillName : newClass.getSkillNames()) {
                if (skills.length() > 80) {
                    executor.sendMessage(ChatColor.GRAY + "Skills: " + skills);
                    skills = new StringBuilder();
                }
                skills.append(skillName).append(" ");
            }
            if (skills.length() > 0) {
                executor.sendMessage(ChatColor.GRAY + "Skills: " + skills);
            }
            if (cost > 0.0) {
                executor.sendMessage(ChatColor.WHITE + "Fee" + ChatColor.GRAY + ": " + ChatColor.WHITE + Heroes.econ.format(cost));
            }
            executor.sendMessage(" ");
            ChatComponents.ConfirmOrCancel.GENERIC.send(executor);
            RaceCommand.this.pendingClassSelections.put(player.getName(), newClass);
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("hero confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return true;
            }
            Player player = (Player)executor;
            Hero hero = RaceCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getRaceClass();
            HeroClass newClass = RaceCommand.this.pendingClassSelections.remove(player.getName());
            double cost = RaceCommand.this.pendingClassCostStatus.remove(player.getName());
            Properties prop = Heroes.properties;
            ClassChangeEvent event = new ClassChangeEvent(hero, currentClass, newClass, cost);
            RaceCommand.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                RaceCommand.this.cancelInteraction((CommandSender)player);
                player.sendMessage(ChatColor.RED + "You're not allowed to join that race");
                return true;
            }
            cost = event.getCost();
            if (currentClass != null && (prop.resetExpOnClassChange && !hero.isMaster(currentClass) || prop.resetMasteryOnClassChange && hero.isMaster(currentClass))) {
                hero.setExperience(currentClass, 0.0);
            }
            if (cost > 0.0) {
                if (Heroes.econ.has((OfflinePlayer)player, cost)) {
                    Heroes.econ.withdrawPlayer((OfflinePlayer)player, cost);
                    player.sendMessage(ChatColor.GREEN + "The Gods are pleased with your offering of " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GREEN + ".");
                } else {
                    player.sendMessage(ChatColor.RED + "You're unable to meet the offering of" + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GREEN + " to become " + ChatColor.WHITE + newClass.getName());
                    return true;
                }
            }
            hero.changeHeroClass(newClass, false, true);
            player.sendMessage(" ");
            player.sendMessage(" ");
            player.sendMessage(ChatColor.GRAY + "You are reborn as a " + ChatColor.WHITE + newClass.getName() + ChatColor.GREEN + "!");
            hero.setCooldown("race-change", System.currentTimeMillis() + Properties.raceCooldown);
            RaceCommand.this.plugin.getCharacterManager().saveHero(hero, false);
            AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, currentClass, newClass, cost);
            RaceCommand.this.plugin.getServer().getPluginManager().callEvent((Event)afterEvent);
            if (afterEvent.isCancelled()) {
                RaceCommand.this.cancelInteraction((CommandSender)player);
                return true;
            }
            return true;
        }
    }
}

