/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ProgressInfoCommand
extends BasicCommand {
    private final Heroes plugin;

    public ProgressInfoCommand(Heroes plugin) {
        super("Progress Information");
        this.plugin = plugin;
        this.setDescription("Displays hero progress information");
        this.setUsage("/hero progress");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("hero progress");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        Set<HeroClass> loadedClasses = this.plugin.getClassManager().getClasses();
        ArrayList<HeroClass> leveledClasses = new ArrayList<HeroClass>();
        for (HeroClass heroClass : loadedClasses) {
            if (!(hero.getExperience(heroClass) > 0.0)) continue;
            leveledClasses.add(heroClass);
        }
        if (leveledClasses.isEmpty()) {
            sender.sendMessage("No leveled class progress to display!");
        } else {
            ProgressInfoCommand.displayClassesInfo(sender, leveledClasses, hero);
        }
        return true;
    }

    public static void displayClassesInfo(CommandSender sender, ArrayList<HeroClass> leveledClasses, Hero hero) {
        String header = ChatColor.RED + "-----[ " + ChatColor.WHITE + "Your Progress Information" + ChatColor.RED + " ]-----";
        sender.sendMessage(header);
        for (HeroClass heroClass : leveledClasses) {
            int level = hero.getHeroLevel(heroClass);
            boolean isMastered = hero.isMaster(heroClass);
            String classesInfoString = ChatColor.GREEN + "Level " + level + " " + ChatColor.WHITE + heroClass.getName();
            if (isMastered) {
                classesInfoString = classesInfoString + ChatColor.GOLD + " (Mastered)";
            }
            sender.sendMessage(classesInfoString);
        }
    }
}

