/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.util.Properties;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ProfessionCommand
extends BasicInteractiveCommand {
    private final Heroes plugin;
    private final Map<String, HeroClass> pendingClassSelections = new HashMap<String, HeroClass>();
    private final Map<String, Double> pendingClassCostStatus = new HashMap<String, Double>();

    public ProfessionCommand(Heroes plugin) {
        super("Choose Profession Class");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Selects a new path or specialization as your profession");
        this.setUsage("/hero profession \u00a79<type>");
    }

    @Override
    public String getCancelIdentifier() {
        return "hero cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingClassSelections.remove(executor.getName());
        this.pendingClassCostStatus.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("hero prof", "hero profession");
            this.setArgumentRange(1, 1);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Properties props = Heroes.properties;
            Player player = (Player)executor;
            Hero hero = ProfessionCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getSecondaryClass();
            HeroClass newClass = ProfessionCommand.this.plugin.getClassManager().getClass(args[0]);
            if (newClass == null) {
                executor.sendMessage(ChatColor.RED + "Class not found.");
                return false;
            }
            Long cooldown = hero.getCooldown("prof-change");
            if (cooldown != null && cooldown > System.currentTimeMillis()) {
                player.sendMessage(ChatColor.RED + "You've changed profession too recently. You must wait " + ChatColor.RED + (cooldown - System.currentTimeMillis()) / 1000L + ChatColor.GRAY + " seconds to change your class.");
                return false;
            }
            if (newClass.equals(currentClass) || newClass.equals(hero.getHeroClass())) {
                executor.sendMessage(ChatColor.RED + "You are already set as this Class.");
                return false;
            }
            if (!newClass.isSecondary()) {
                executor.sendMessage(ChatColor.RED + "That is not a secondary Class!");
                return false;
            }
            if (currentClass != null) {
                if (!currentClass.isDefaultProf() && hero.isMaster(currentClass) && currentClass.getParents().isEmpty() && props.lockAtHighestTier) {
                    executor.sendMessage(ChatColor.RED + "You have mastered your class and can not choose a new one!");
                    return false;
                }
                if (!hero.isMaster(currentClass) && props.lockPathTillMaster) {
                    executor.sendMessage(ChatColor.RED + "You must master this class before swapping to another.");
                    return false;
                }
            }
            if (!newClass.hasNoParents()) {
                for (HeroClass parentClass : newClass.getStrongParents()) {
                    if (hero.isMaster(parentClass)) continue;
                    executor.sendMessage(ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + " requires you to master: " + newClass.getStrongParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
                boolean masteredOne = false;
                for (HeroClass parentClass : newClass.getWeakParents()) {
                    if (!hero.isMaster(parentClass)) continue;
                    masteredOne = true;
                    break;
                }
                if (!masteredOne && !newClass.getWeakParents().isEmpty()) {
                    executor.sendMessage(ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + " requires you to master one of: " + newClass.getWeakParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
            }
            if (!newClass.isDefaultProf() && !CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + newClass.getName().toLowerCase())) {
                executor.sendMessage(ChatColor.GRAY + "You don't have permission for " + ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + ".");
                return false;
            }
            double cost = newClass.getCost();
            if ((currentClass == null || currentClass.isDefaultProf()) && props.firstSwitchFree) {
                cost = 0.0;
            } else if (hero.getExperience(newClass) > 0.0) {
                cost = props.oldProfSwapCost + props.oldProfSwapCostPerLevel * (double)hero.getHeroLevel(newClass);
            }
            if (props.swapWithMasteriesHasFullCost && hero.getMasteredClasses().size() >= props.numberOfMasteriesForFullCost) {
                cost = props.oldProfSwapCost + props.oldProfSwapCostPerLevel * (double)newClass.getMaxLevel();
            }
            if (hero.isMaster(newClass) && props.swapMasterFree) {
                cost = 0.0;
            } else if (!props.economy || Heroes.econ == null || cost <= 0.0) {
                cost = 0.0;
            }
            if (props.economy && cost > 0.0 && !Heroes.econ.has((OfflinePlayer)player, cost)) {
                player.sendMessage(ChatColor.GRAY + "It will cost " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GRAY + " to switch professions, you only have " + ChatColor.WHITE + Heroes.econ.getBalance((OfflinePlayer)player));
                return false;
            }
            ProfessionCommand.this.pendingClassCostStatus.put(player.getName(), cost);
            executor.sendMessage(" ");
            executor.sendMessage(ChatColor.GRAY + "You have chosen...");
            executor.sendMessage(ChatColor.GREEN + "\u00bb  " + ChatColor.BLUE + newClass.getName() + ChatColor.WHITE + ": " + ChatColor.GRAY + newClass.getDescription().toLowerCase());
            StringBuilder skills = new StringBuilder();
            for (String skillName : newClass.getSkillNames()) {
                if (skills.length() > 80) {
                    executor.sendMessage(ChatColor.GRAY + "Skills: " + skills);
                    skills = new StringBuilder();
                }
                skills.append(skillName).append(" ");
            }
            if (skills.length() > 0) {
                executor.sendMessage(ChatColor.GRAY + "Skills: " + skills);
            }
            if (cost > 0.0) {
                executor.sendMessage(ChatColor.WHITE + "Fee" + ChatColor.GRAY + ": " + ChatColor.WHITE + Heroes.econ.format(cost));
            }
            executor.sendMessage(" ");
            ChatComponents.ConfirmOrCancel.GENERIC.send(executor);
            ProfessionCommand.this.pendingClassSelections.put(player.getName(), newClass);
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("hero confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return true;
            }
            Player player = (Player)executor;
            Hero hero = ProfessionCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getSecondaryClass();
            HeroClass newClass = ProfessionCommand.this.pendingClassSelections.remove(player.getName());
            double cost = ProfessionCommand.this.pendingClassCostStatus.remove(player.getName());
            Properties prop = Heroes.properties;
            ClassChangeEvent event = new ClassChangeEvent(hero, currentClass, newClass, cost);
            ProfessionCommand.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                ProfessionCommand.this.cancelInteraction((CommandSender)player);
                player.sendMessage(ChatColor.RED + "You're not allowed to join that class");
                return true;
            }
            cost = event.getCost();
            if (currentClass != null && (prop.resetExpOnClassChange && !hero.isMaster(currentClass) || prop.resetMasteryOnClassChange && hero.isMaster(currentClass))) {
                hero.setExperience(currentClass, 0.0);
            }
            if (cost > 0.0) {
                if (Heroes.econ.has((OfflinePlayer)player, cost)) {
                    Heroes.econ.withdrawPlayer((OfflinePlayer)player, cost);
                    player.sendMessage(ChatColor.GREEN + "The Gods are pleased with your offering of " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GREEN + ".");
                } else {
                    player.sendMessage(ChatColor.RED + "You're unable to meet the offering of" + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GREEN + " to become " + ChatColor.WHITE + newClass.getName());
                    return true;
                }
            }
            hero.changeHeroClass(newClass, true, false);
            player.sendMessage(" ");
            player.sendMessage(" ");
            player.sendMessage(ChatColor.GRAY + "Welcome to the path of the " + ChatColor.WHITE + newClass.getName() + ChatColor.GREEN + "!");
            hero.setCooldown("prof-change", System.currentTimeMillis() + Properties.profCooldown);
            ProfessionCommand.this.plugin.getCharacterManager().saveHero(hero, false);
            AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, currentClass, newClass, cost);
            ProfessionCommand.this.plugin.getServer().getPluginManager().callEvent((Event)afterEvent);
            if (afterEvent.isCancelled()) {
                ProfessionCommand.this.cancelInteraction((CommandSender)player);
                return true;
            }
            return true;
        }
    }
}

