/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.CommandHandler;
import java.util.ArrayList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.pagination.PaginatedResult;

public class PathsCommand
extends BasicCommand {
    private static final String CHOOSE_COMPONENT = ChatColor.GRAY + "To choose a path, click on the " + ChatComponents.BUTTON_SELECT + ChatColor.GRAY + " button.";
    private static final String CHOOSE_FALLBACK = ChatColor.GRAY + "To choose a path, type " + ChatColor.GREEN + "/hero choose <path>" + ChatColor.GRAY + " or " + ChatColor.GREEN + "/hero prof <prof>" + ChatColor.GRAY + " or " + ChatColor.GREEN + "/hero race <race>" + ChatColor.GRAY + ".";
    private final Heroes plugin;

    public PathsCommand(Heroes plugin) {
        super("Paths");
        this.plugin = plugin;
        this.setDescription("Lists all paths available to you, primary, professions and races!");
        this.setUsage("/hero paths \u00a78[page#] [prim|prof|race]");
        this.setArgumentRange(0, 2);
        this.setIdentifiers("hero paths");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players may use this command.");
            return false;
        }
        int page = 1;
        boolean primaryOnly = false;
        boolean secondaryOnly = false;
        boolean raceOnly = false;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ignored) {
                if (args[0].toLowerCase().contains("prim")) {
                    primaryOnly = true;
                }
                if (args[0].toLowerCase().contains("prof")) {
                    secondaryOnly = true;
                }
                if (args[0].toLowerCase().contains("race")) {
                    raceOnly = true;
                }
                sender.sendMessage(ChatColor.RED + "Please provide a valid page number or either of prim, prof, race.");
                return false;
            }
            if (args.length > 1) {
                if (args[1].toLowerCase().contains("prim")) {
                    primaryOnly = true;
                } else if (args[1].toLowerCase().contains("prof")) {
                    secondaryOnly = true;
                } else if (args[1].toLowerCase().contains("race")) {
                    raceOnly = true;
                }
            }
        }
        boolean anyClass = !primaryOnly && !secondaryOnly && !raceOnly;
        final Hero hero = this.plugin.getCharacterManager().getHero((Player)sender);
        ArrayList<HeroClass> paths = new ArrayList<HeroClass>();
        for (HeroClass hc : this.plugin.getClassManager().getClasses()) {
            if (hc.getTier() != 1 || !hc.isDefault() && !CommandHandler.hasPermission(sender, "heroes.classes." + hc.getName().toLowerCase()) && hc.isRace() && !CommandHandler.hasPermission(sender, "heroes.races." + hc.getName().toLowerCase()) || !(anyClass || primaryOnly && hc.isPrimary() || secondaryOnly && hc.isSecondary()) && (!raceOnly || !hc.isRace())) continue;
            paths.add(hc);
        }
        String pageHeader = ChatColor.DARK_AQUA + "Hero Paths";
        Object pageCommand = "/hero paths {INDEX}";
        if (primaryOnly) {
            pageHeader = pageHeader + " - Primary";
            pageCommand = (String)pageCommand + " prim";
        } else if (secondaryOnly) {
            pageHeader = pageHeader + " - Secondary";
            pageCommand = (String)pageCommand + " prof";
        } else if (raceOnly) {
            pageHeader = pageHeader + " - Race";
            pageCommand = (String)pageCommand + " race";
        }
        new PaginatedResult<HeroClass>(pageHeader, (String)pageCommand){

            @Override
            protected BaseComponent[] build(HeroClass entry, int index) {
                boolean heroHas;
                String name = entry.getName();
                ComponentBuilder builder = new ComponentBuilder("  ");
                boolean heroHasFirst = hero.getHeroClass() == entry;
                boolean heroHasSecond = hero.getSecondaryClass() != null && hero.getSecondaryClass() == entry;
                boolean heroHasRace = hero.getRaceClass() != null && hero.getRaceClass() == entry;
                boolean bl = heroHas = heroHasFirst || heroHasSecond || heroHasRace;
                if (entry.isPrimary() && !heroHas) {
                    builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Select").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hero choose " + name)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Select class").color(ChatUtil.toBungee(ChatColor.BLUE)).append(" - ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("/hero choose " + name).color(ChatUtil.toBungee(ChatColor.GOLD)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
                }
                if (entry.isSecondary() && !heroHas) {
                    if (entry.isPrimary()) {
                        Heroes.getInstance().getLogger().warning("Class '" + name + "' is both primary and secondary.");
                    }
                    builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Select").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hero prof " + name)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Select class").color(ChatUtil.toBungee(ChatColor.BLUE)).append(" - ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("/hero prof " + name).color(ChatUtil.toBungee(ChatColor.GOLD)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
                }
                if (entry.isRace() && !heroHas) {
                    if (entry.isPrimary()) {
                        Heroes.getInstance().getLogger().warning("Class '" + name + "' is both primary and race.");
                    }
                    builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Select").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hero race " + name)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Select Race").color(ChatUtil.toBungee(ChatColor.BLUE)).append(" - ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("/hero race " + name).color(ChatUtil.toBungee(ChatColor.GOLD)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
                }
                if (heroHas) {
                    builder.append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("Select").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("This is already your ").color(ChatUtil.toBungee(ChatColor.YELLOW)).append(heroHasFirst ? "primary" : (heroHasSecond ? "secondary" : "race")).color(ChatUtil.toBungee(ChatColor.YELLOW)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null);
                }
                String description = entry.getDescription();
                builder.append("  ").append(name).color(ChatUtil.toBungee(ChatColor.GREEN)).append(" - ").color(ChatUtil.toBungee(ChatColor.WHITE));
                if (description != null && !description.isEmpty()) {
                    builder.append(description).color(ChatUtil.toBungee(ChatColor.GRAY));
                }
                return builder.create();
            }

            @Override
            protected String buildFallback(HeroClass entry, int index) {
                return PathsCommand.getLegacyText(entry, entry.getDescription());
            }

            @Override
            protected void after(CommandSender viewer, ChatSendResult chatSendResult) {
                if (chatSendResult == ChatSendResult.FALLBACK) {
                    viewer.sendMessage(CHOOSE_FALLBACK);
                } else {
                    viewer.sendMessage(CHOOSE_COMPONENT);
                }
            }
        }.display(sender, paths, page);
        return true;
    }

    @Deprecated
    private static String getLegacyText(HeroClass clazz, String description) {
        Object prefix = "";
        if (clazz.isPrimary()) {
            prefix = (String)prefix + "Pri";
        }
        if (clazz.isSecondary()) {
            if (StringUtils.isNotEmpty((String)prefix)) {
                prefix = (String)prefix + " | ";
                prefix = "  \u00a7d" + (String)prefix;
            } else {
                prefix = (String)prefix + "  \u00a7c";
            }
            prefix = (String)prefix + "Prof";
        } else if (clazz.isPrimary()) {
            prefix = "  \u00a79" + (String)prefix;
        }
        if (description != null && !description.isEmpty()) {
            return (String)prefix + " | \u00a7a" + clazz.getName() + " - \u00a7f" + description;
        }
        return (String)prefix + " | \u00a7a" + clazz.getName();
    }
}

