/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyModeCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyModeCommand(Heroes plugin) {
        super("Party Mode");
        this.plugin = plugin;
        this.setDescription("Toggles party pvp");
        this.setUsage("/party mode \u00a79<pvp>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party mode");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (hero.getParty() == null) {
            sender.sendMessage(ChatColor.RED + "You are not in a party.");
            return false;
        }
        HeroParty heroParty = hero.getParty();
        if (heroParty.getLeader().equals(hero)) {
            if (args[0].equalsIgnoreCase("pvp")) {
                boolean partMemberInCombat = false;
                for (Hero pHero : heroParty.getMembers()) {
                    if (!pHero.isInCombat()) continue;
                    partMemberInCombat = true;
                    break;
                }
                if (partMemberInCombat) {
                    sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You can't use that command while any party members are in combat!");
                    return false;
                }
                heroParty.pvpToggle();
                return true;
            }
            return false;
        }
        sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "Sorry, you need to be the leader to do that!");
        return false;
    }
}

