/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.feature.roll.ItemRollType;
import com.herocraftonline.heroes.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyLeaveCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyLeaveCommand(Heroes plugin) {
        super("Party Leave");
        this.plugin = plugin;
        this.setDescription("Leaves your party");
        this.setUsage("/party leave");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("party leave");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        Util.leaveParty(this.plugin, hero, HeroLeavePartyEvent.LeavePartyReason.COMMAND);
        hero.itemRollType = ItemRollType.NEED;
        sender.sendMessage(ChatColor.GRAY + "Your new roll option is " + ChatColor.GREEN + hero.itemRollType.name());
        return true;
    }
}

