/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyLeadCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyLeadCommand(Heroes plugin) {
        super("Party Lead");
        this.plugin = plugin;
        this.setDescription("Checks or sets the leader of the party.");
        this.setUsage("/party lead \u00a79<player>");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("party lead", "party leader");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroParty party = hero.getParty();
        if (party == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You don't have a party!");
            return true;
        }
        if (party.getLeader() == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "The party has no leader!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.GRAY + "The current party leader is " + ChatColor.WHITE + party.getLeader().getPlayer().getName() + ChatColor.GRAY + ".");
            return true;
        }
        if (!party.getLeader().equals(hero)) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "Only the leader of a part can give leadership to another hero!");
            return true;
        }
        Player tPlayer = this.plugin.getServer().getPlayer(args[0]);
        if (tPlayer == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "That player is not in your party!");
            return true;
        }
        Hero tHero = null;
        for (Hero found : party.getMembers()) {
            if (!found.getPlayer().equals(tPlayer)) continue;
            tHero = found;
            break;
        }
        if (tHero == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "That player is not in your party.");
            Heroes.log(Level.INFO, "Hero not Found.");
            return true;
        }
        party.setLeader(tHero);
        party.messageParty(tHero.getPlayer().getName() + ChatColor.GRAY + " is now the party leader.");
        return true;
    }
}

