/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroLeavePartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyKickCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyKickCommand(Heroes plugin) {
        super("Party Kick");
        this.plugin = plugin;
        this.setDescription("Kicks a player from the party");
        this.setUsage("/party kick \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party kick");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroParty party = hero.getParty();
        if (party == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You don't have a party!");
            return true;
        }
        if (party.getLeader() == null || !party.getLeader().equals(hero)) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You must be the leader to kick players from the party.");
            return true;
        }
        Player tPlayer = this.plugin.getServer().getPlayer(args[0]);
        if (tPlayer == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "That player is not in your party.");
            return true;
        }
        Hero tHero = null;
        for (Hero found : party.getMembers()) {
            if (!found.getPlayer().equals(tPlayer)) continue;
            tHero = found;
            break;
        }
        if (tHero == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "That player is not in your party.");
            return true;
        }
        HeroParty heroParty = hero.getParty();
        HeroLeavePartyEvent event = new HeroLeavePartyEvent(tHero, heroParty, HeroLeavePartyEvent.LeavePartyReason.KICK);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You can not kick the player from the party at this time!");
            return true;
        }
        heroParty.messageParty(tPlayer.getDisplayName() + ChatColor.GRAY + " has been kicked from the party");
        heroParty.removeMember(tHero);
        return true;
    }
}

