/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.PartyInviteEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.party.PartyChannelManager;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.util.NMSHacks;

public class PartyInviteCommand
extends BasicCommand {
    private final Heroes plugin;
    private final PartyChannelManager channelManager;

    public PartyInviteCommand(Heroes plugin) {
        super("Party Invite");
        this.plugin = plugin;
        this.channelManager = plugin.getPartyChannelManager();
        this.setDescription("Invites a player to your party");
        this.setUsage("/party invite \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party invite");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        HeroParty party;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can create parties");
            return false;
        }
        Player player = (Player)sender;
        Player target = this.plugin.getServer().getPlayer(args[0]);
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (target == null) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "Player not found.");
            return false;
        }
        if (target.equals(player)) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You cannot invite yourself.");
            return false;
        }
        if (hero.getParty() == null) {
            HeroParty newParty = new HeroParty(hero, this.plugin);
            this.plugin.getPartyManager().addParty(newParty);
            if (this.channelManager != null) {
                this.channelManager.messageParty(newParty, "Your party has been created.");
            } else {
                sender.sendMessage(ChatColor.GREEN + "Your party has been created");
            }
        }
        if ((party = hero.getParty()).getLeader() == null || !party.getLeader().equals(hero)) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "You are not leader of this party.");
            return false;
        }
        int memberCount = party.getMembers().size();
        if (memberCount >= Heroes.properties.maxPartySize) {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "Your party is full!");
            return false;
        }
        if (memberCount + party.getInviteCount() >= Heroes.properties.maxPartySize) {
            party.removeOldestInvite();
        }
        party.addInvite(target.getName());
        Bukkit.getPluginManager().callEvent((Event)new PartyInviteEvent(this.plugin.getCharacterManager().getHero(target), party));
        target.sendMessage(ChatComponents.CHANNEL_PARTY + player.getName() + " has invited you to their party");
        BaseComponent[] components = new ComponentBuilder("[Party] ").color(ChatUtil.toBungee(ChatColor.GREEN)).append("Click ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("here").event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/party accept " + player.getName())).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/party accept " + player.getName()).create())).color(ChatUtil.toBungee(ChatColor.DARK_AQUA)).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(" to accept ").color(ChatUtil.toBungee(ChatColor.GRAY)).append(player.getName()).color(ChatUtil.toBungee(ChatColor.WHITE)).append("'s invitation.").color(ChatUtil.toBungee(ChatColor.GRAY)).create();
        NMSHacks.sendMessage((CommandSender)target, components, ChatColor.GREEN + "[Party] " + ChatColor.WHITE + "Type /party accept " + player.getName() + ChatColor.WHITE + " to join.");
        player.sendMessage(ChatColor.GREEN + "[Party] " + target.getName() + ChatColor.WHITE + " has been invited to your party");
        return true;
    }
}

