/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.google.common.base.Strings;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.command.CommandHandler;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class PartyHelpCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyHelpCommand(Heroes plugin) {
        super("Party Help");
        this.plugin = plugin;
        this.setDescription("Displays the party help menu.");
        this.setUsage("/party help");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("party help");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        CommandHandler commandHandler = this.plugin.getCommandHandler();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(commandHandler.getCommand("Party Help"));
        commands.add(commandHandler.getCommand("Party Invite"));
        commands.add(commandHandler.getCommand("Party Accept"));
        commands.add(commandHandler.getCommand("Party Chat"));
        commands.add(commandHandler.getCommand("Party Kick"));
        commands.add(commandHandler.getCommand("Party Lead"));
        commands.add(commandHandler.getCommand("Party Leave"));
        commands.add(commandHandler.getCommand("Party Mode"));
        commands.add(commandHandler.getCommand("Party Who"));
        String dashes = Strings.repeat((String)"-", (int)8);
        String header = ChatColor.DARK_GRAY + dashes + ChatColor.DARK_AQUA + " Heroes Party Help " + ChatColor.DARK_GRAY + dashes + "\n";
        StringBuilder message = new StringBuilder(header);
        for (Command command : commands) {
            message.append(ChatColor.DARK_AQUA).append(command.getUsage()).append(ChatColor.WHITE).append(" - ").append(ChatColor.GRAY).append(command.getDescription()).append("\n");
        }
        sender.sendMessage(message.toString());
        return true;
    }
}

