/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.PartyChatEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyChatCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyChatCommand(Heroes plugin) {
        super("Party Chat");
        this.plugin = plugin;
        this.setDescription("Sends messages to your party");
        this.setUsage("/party \u00a79<msg> OR /p \u00a79<msg>");
        this.setArgumentRange(0, 1000);
        this.setIdentifiers("pc", "p", "party");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        HeroParty party = hero.getParty();
        if (party == null) {
            player.sendMessage(ChatColor.RED + "You are not in a party.");
            return false;
        }
        Set<Hero> partyMembers = party.getMembers();
        if (partyMembers.size() <= 1) {
            player.sendMessage(ChatColor.RED + "Your party is empty.");
            return false;
        }
        if (args.length > 0) {
            StringBuilder msg = new StringBuilder();
            for (String word : args) {
                msg.append(word).append(' ');
            }
            Object fullMsg = msg.toString().trim();
            PartyChatEvent pce = new PartyChatEvent(hero, party, (String)fullMsg);
            Bukkit.getPluginManager().callEvent((Event)pce);
            if (pce.isCancelled()) {
                return true;
            }
            fullMsg = pce.getMessage();
            fullMsg = player.equals(party.getLeader().getPlayer()) ? "\u00a7a[Party] \u00a7e" + player.getDisplayName() + "\u00a7a:\u00a73 " + (String)fullMsg : "\u00a7a[Party] \u00a77" + player.getDisplayName() + "\u00a7a:\u00a73 " + (String)fullMsg;
            for (Hero partyMember : partyMembers) {
                partyMember.getPlayer().sendMessage((String)fullMsg);
            }
            Heroes.log(Level.INFO, (String)fullMsg);
            return true;
        }
        return false;
    }
}

