/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.HeroJoinPartyEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PartyAcceptCommand
extends BasicCommand {
    private final Heroes plugin;

    public PartyAcceptCommand(Heroes plugin) {
        super("Party Accept");
        this.plugin = plugin;
        this.setDescription("Accept a party invite");
        this.setUsage("/party accept \u00a79<player>");
        this.setArgumentRange(1, 1);
        this.setIdentifiers("party accept");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (this.plugin.getServer().getPlayer(args[0]) != null) {
            Player newPlayer = this.plugin.getServer().getPlayer(args[0]);
            Hero newHero = this.plugin.getCharacterManager().getHero(newPlayer);
            if (hero.getParty() != null) {
                sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.RED + "Sorry, you're already in a party.");
                return false;
            }
            if (newHero.getParty() != null && newHero.getParty().isInvited(player.getName())) {
                HeroJoinPartyEvent event = new HeroJoinPartyEvent(hero, newHero.getParty());
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return false;
                }
                HeroParty party = newHero.getParty();
                party.addMember(hero);
                party.messageParty(player.getName() + ChatColor.GRAY + " has joined the party");
                sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.GRAY + "You're now in " + ChatColor.WHITE + newPlayer.getName() + ChatColor.GRAY + "'s party");
                party.removeInvite(player);
                hero.itemRollType = null;
                sender.sendMessage(ChatColor.GRAY + "Your roll option has been removed.");
            } else {
                sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatColor.GRAY + "Sorry, " + ChatColor.WHITE + newPlayer.getName() + ChatColor.GRAY + " hasn't invited you to their party");
            }
        } else {
            sender.sendMessage(ChatComponents.CHANNEL_PARTY + ChatComponents.CHANNEL_PARTY + ChatColor.GRAY + "Sorry, " + ChatColor.WHITE + args[0] + ChatColor.GRAY + " doesn't match anyone in-game");
        }
        return true;
    }
}

