/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NPCInfoCommand
extends BasicCommand {
    Heroes plugin;

    public NPCInfoCommand(Heroes plugin) {
        super("NPCInfo");
        this.setIdentifiers("hero npc info");
        this.setDescription("Gets information on currently selected (/npc select) NPC");
        this.setArgumentRange(0, 0);
        this.setUsage("/hero npc info");
        this.setPermission("heroes.npc.info");
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        NPC selected = ((Citizens)CitizensAPI.getPlugin()).getNPCSelector().getSelected(sender);
        if (selected == null) {
            Messaging.send((CommandSender)player, "You have no NPCs selected!", new Object[0]);
            return true;
        }
        if (!(selected.getEntity() instanceof Player)) {
            Messaging.send((CommandSender)player, "Setting classes on non-player NPCs is not supported at this time", new Object[0]);
            return true;
        }
        Hero hero = this.plugin.getCharacterManager().getHero((Player)selected.getEntity());
        Messaging.send(sender, "\u00a7c-----[\u00a7f $1 (ID: $2) \u00a7c ]-----", selected.getName(), selected.getId());
        Messaging.send(sender, "Primary Class: $1 | $2", hero.getHeroClass().getName(), hero.getHeroLevel(hero.getHeroClass()));
        if (hero.getSecondaryClass() != null) {
            Messaging.send(sender, "Secondary Class: $1 | $2", hero.getSecondaryClass().getName(), hero.getHeroLevel(hero.getSecondaryClass()));
        }
        Messaging.send(sender, "Health: $1/$2", hero.getPlayer().getHealth(), hero.getPlayer().getMaxHealth());
        return true;
    }
}

