/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.Messaging;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class NPCCommand
extends BasicCommand {
    private Heroes plugin;

    public NPCCommand(Heroes plugin) {
        super("NPCCommand");
        this.plugin = plugin;
        this.setArgumentRange(1, 2);
        this.setIdentifiers("hero npc");
        this.setUsage("/hero npc [reset]|[class|prof classname]");
        this.setDescription("Set (or reset) selected (/npc select) NPC's active Hero class and profession");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        NPC selected = ((Citizens)CitizensAPI.getPlugin()).getNPCSelector().getSelected(sender);
        if (selected == null) {
            Messaging.send((CommandSender)player, "You have no NPCs selected!", new Object[0]);
            return true;
        }
        if (!(selected.getEntity() instanceof Player)) {
            Messaging.send((CommandSender)player, "Setting classes on non-player NPCs is not supported at this time", new Object[0]);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reset")) {
                boolean flag = false;
                flag = ((Owner)selected.getTrait(Owner.class)).isOwnedBy(sender) ? sender.hasPermission("heroes.npc.reset") : sender.hasPermission("heroes.npc.reset.others");
                if (!flag) {
                    sender.sendMessage("Insufficient Permission");
                    return false;
                }
                Hero hero = this.plugin.getCharacterManager().getHero((Player)selected.getEntity());
                this.resetHero(hero);
                this.plugin.getCharacterManager().saveHero(hero, false);
                sender.sendMessage("Class reset");
                return true;
            }
            return false;
        }
        if (args.length == 2) {
            boolean flag = false;
            flag = ((Owner)selected.getTrait(Owner.class)).isOwnedBy(sender) ? sender.hasPermission("heroes.npc.class") : sender.hasPermission("heroes.npc.class.others");
            if (!flag) {
                sender.sendMessage("Insufficient Permission");
                return false;
            }
            if (args[0].equalsIgnoreCase("class")) {
                String className = args[1];
                HeroClass hc = this.plugin.getClassManager().getClass(className);
                if (hc != null && hc.isPrimary()) {
                    Hero hero = this.plugin.getCharacterManager().getHero((Player)selected.getEntity());
                    hero.setHeroClass(hc, false, false);
                    this.plugin.getCharacterManager().saveHero(hero, false);
                    sender.sendMessage("Class changed");
                } else {
                    sender.sendMessage("Class " + className + " not found or is not a primary class!");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("prof")) {
                String className = args[1];
                HeroClass hc = this.plugin.getClassManager().getClass(className);
                if (hc != null && hc.isSecondary()) {
                    Hero hero = this.plugin.getCharacterManager().getHero((Player)selected.getEntity());
                    hero.setHeroClass(hc, true, false);
                    this.plugin.getCharacterManager().saveHero(hero, false);
                    sender.sendMessage("Class changed");
                } else {
                    sender.sendMessage("Class " + className + " not found or is not a secondary class!");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void resetHero(Hero hero) {
        HeroClass defaultClass = this.plugin.getClassManager().getDefaultClass();
        hero.silentClearEffects(false);
        hero.clearSummons();
        hero.clearExperience();
        hero.clearCooldowns();
        hero.clearBinds();
        hero.clearMasteries();
        ClassChangeEvent event = new ClassChangeEvent(hero, hero.getHeroClass(), defaultClass, 0.0, false, true);
        Bukkit.getPluginManager().callEvent((Event)event);
        hero.setHeroClass(defaultClass, false, false);
        event = new ClassChangeEvent(hero, hero.getSecondaryClass(), null, 0.0);
        Bukkit.getPluginManager().callEvent((Event)event);
        hero.setHeroClass(null, true, true);
        hero.syncExperience(defaultClass);
        this.plugin.getCharacterManager().performSkillChecks(hero);
    }
}

