/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class LeaderboardCommand
extends BasicCommand {
    private final Heroes plugin;

    public LeaderboardCommand(Heroes plugin) {
        super("Leaderboard");
        this.plugin = plugin;
        this.setDescription("Displays Hero rankings");
        this.setUsage("/hero leaderboard");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("hero leaderboard");
        this.setPermission("heroes.leaderboard");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Collection<Hero> heroes = this.plugin.getCharacterManager().getHeroes();
        TreeMap<Hero, Double> leaderboard = new TreeMap<Hero, Double>(new Comparator<Hero>(){

            @Override
            public int compare(Hero h1, Hero h2) {
                return (int)(h1.getExperience(h1.getHeroClass()) - h2.getExperience(h2.getHeroClass()));
            }
        });
        for (Hero hero : heroes) {
            if (hero == null) continue;
            leaderboard.put(hero, hero.getExperience(hero.getHeroClass()));
        }
        Iterator iter = leaderboard.entrySet().iterator();
        for (int i = 0; i < 5 && iter.hasNext(); ++i) {
            Map.Entry entry = iter.next();
            sender.sendMessage(ChatColor.WHITE + ((Hero)entry.getKey()).getPlayer().getName() + ChatColor.GRAY + " - " + ChatColor.WHITE + entry.getValue());
        }
        return true;
    }
}

