/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Messaging;
import com.herocraftonline.heroes.util.Properties;
import com.herocraftonline.heroes.util.Util;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoCommand
extends BasicCommand {
    private final Heroes plugin;

    public InfoCommand(Heroes plugin) {
        super("Info");
        this.plugin = plugin;
        this.setDescription("Displays information about you, such as level and allowed armor");
        this.setUsage("/hero info \u00a79<player>");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero info");
        this.setPermission("heroes.info");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        Player player;
        boolean me = false;
        if (!(sender instanceof Player) && args.length < 1) {
            sender.sendMessage("/hero info requires a username from the console");
            return false;
        }
        if (args.length < 1) {
            player = (Player)sender;
            me = true;
        } else {
            if (!sender.hasPermission("heroes.info.other")) {
                sender.sendMessage(ChatColor.RED + "Insufficient permission.");
                return true;
            }
            Player searchedPlayer = this.plugin.getServer().getPlayer(args[0]);
            if (searchedPlayer == null) {
                Messaging.send(sender, "That player is not online!", new Object[0]);
                return false;
            }
            if (sender instanceof Player && !((Player)sender).canSee(searchedPlayer)) {
                Messaging.send(sender, "That player is not online!", new Object[0]);
                return false;
            }
            player = searchedPlayer;
        }
        if (me) {
            sender.sendMessage("\u00a7c--------[ \u00a7fYour Stats\u00a7c ]--------");
        } else {
            sender.sendMessage("\u00a7c--------[ \u00a7f" + player.getName() + "'s Stats\u00a7c ]--------");
        }
        this.printStats(this.plugin.getCharacterManager().getHero(player), sender, me || sender.isOp());
        return true;
    }

    private void printStats(Hero hero, CommandSender sender, boolean privileged) {
        List<String> masteredClasses;
        HeroClass prim = hero.getHeroClass();
        HeroClass sec = hero.getSecondaryClass();
        HeroClass race = hero.getRaceClass();
        HeroClass global = HeroClass.getGlobalSkillset();
        StringBuilder sb = new StringBuilder("Lv. \u00a76");
        sb.append(hero.getHeroLevel(prim));
        sb.append(" \u00a7a");
        sb.append(prim.getName());
        if (sec != null) {
            sb.append("\u00a7r, Lv. \u00a76");
            sb.append(hero.getHeroLevel(sec));
            sb.append(" \u00a79");
            sb.append(sec.getName());
        }
        if (race != null) {
            sb.append("\u00a7r, \u00a73");
            sb.append(race.getName());
        }
        sender.sendMessage(sb.toString());
        if (privileged) {
            int exp = (int)hero.getExperience(prim);
            int level = Properties.getLevel(exp);
            int levelStart = Properties.getTotalExp(level);
            int levelEnd = Properties.getTotalExp(level + 1);
            sender.sendMessage("XP in \u00a7a" + prim.getName() + "\u00a7r " + ChatComponents.Bars.experience(exp, levelStart, levelEnd));
            if (sec != null) {
                exp = (int)hero.getExperience(sec);
                level = Properties.getLevel(exp);
                levelStart = Properties.getTotalExp(level);
                levelEnd = Properties.getTotalExp(level + 1);
                sender.sendMessage("XP in \u00a79" + sec.getName() + "\u00a7r " + ChatComponents.Bars.experience(exp, levelStart, levelEnd));
            }
        }
        if (!(masteredClasses = hero.getMasteredClasses()).isEmpty()) {
            sb = new StringBuilder("\u00a76Mastered (Lv. ");
            sb.append(Properties.maxLevel);
            sb.append("): ");
            boolean first = true;
            for (String s : masteredClasses) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(s);
            }
            sender.sendMessage(sb.toString());
        }
        int hp = (int)hero.getPlayer().getHealth();
        int maxHP = (int)hero.getPlayer().getMaxHealth();
        int mana = hero.getMana();
        int maxMana = hero.getMaxMana();
        double manaRegen = hero.getManaRegen();
        sb = new StringBuilder("\u00a72HP: \u00a7r");
        sb.append(hp);
        sb.append("\u00a72/\u00a7r");
        sb.append(maxHP);
        sb.append(" | ");
        sb.append("\u00a79Mana: \u00a7r");
        sb.append(mana);
        sb.append("\u00a79/\u00a7r");
        sb.append(maxMana);
        sb.append(" | ");
        sb.append("\u00a79Mana regen: \u00a7r");
        sb.append(manaRegen);
        sender.sendMessage(sb.toString());
        if (privileged) {
            int usedSkillPreparePoints = hero.getUsedSkillPreparePoints();
            int totalSkillPreparePoints = hero.getTotalSkillPreparePoints();
            int preparedSkillCount = hero.getPreparedSkillCount();
            int preparedSkillLimit = hero.getPreparedSkillLimit();
            sb = new StringBuilder("\u00a79Skill points: \u00a7r");
            sb.append(usedSkillPreparePoints);
            sb.append("\u00a79/\u00a7r");
            sb.append(totalSkillPreparePoints);
            sb.append(" | ");
            sb.append("\u00a79Prepared skills: \u00a7r");
            sb.append(preparedSkillCount);
            sb.append("\u00a79/\u00a7r");
            sb.append(preparedSkillLimit);
            sender.sendMessage(sb.toString());
        }
        EnumSet<Material> allArmors = EnumSet.noneOf(Material.class);
        EnumSet<Material> allWeapons = EnumSet.noneOf(Material.class);
        allArmors.addAll(prim.getAllowedArmor());
        allWeapons.addAll(prim.getAllowedWeapons());
        if (sec != null) {
            allArmors.addAll(sec.getAllowedArmor());
            allWeapons.addAll(sec.getAllowedWeapons());
        }
        if (race != null) {
            allArmors.addAll(race.getAllowedArmor());
            allWeapons.addAll(race.getAllowedWeapons());
        }
        if (!Heroes.properties.useToolsInPermittedWeapons) {
            for (String materialString : Util.picks) {
                Material material = Material.matchMaterial((String)materialString);
                if (material == null) continue;
                allWeapons.add(material);
            }
        }
        allArmors.removeIf(armor -> !hero.isAllowedArmor(prim, (Material)armor) && !hero.isAllowedArmor(sec, (Material)armor) && !hero.isAllowedArmor(race, (Material)armor));
        allWeapons.removeIf(weapon -> !hero.isAllowedWeapon(prim, (Material)weapon) && !hero.isAllowedWeapon(sec, (Material)weapon) && !hero.isAllowedWeapon(race, (Material)weapon));
        sender.sendMessage(MaterialUtil.getArmorRestrictionString(allArmors));
        sender.sendMessage(MaterialUtil.getWeaponRestrictionString(allWeapons));
    }
}

