/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.command.BasicCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoBarCommand
extends BasicCommand {
    private final Heroes plugin;

    public InfoBarCommand(Heroes plugin) {
        super("infobar");
        this.plugin = plugin;
        this.setArgumentRange(0, 1);
        this.setUsage("/hero infobar - Toggle the action bar");
        this.setDescription("Toggle the action bar");
        this.setIdentifiers("hero infobar", "hero actionbar");
    }

    @Override
    public boolean execute(CommandSender executor, String identifier, String[] args) {
        if (!(executor instanceof Player)) {
            return false;
        }
        Player player = (Player)executor;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        if (!hero.getRecordBar().getCurrent().canOverridePlayer()) {
            if (args.length >= 1) {
                switch (args[0].toLowerCase()) {
                    case "true": 
                    case "yes": 
                    case "on": {
                        InfoBarCommand.toggle(executor, hero, true);
                        break;
                    }
                    case "false": 
                    case "no": 
                    case "off": {
                        InfoBarCommand.toggle(executor, hero, false);
                    }
                }
            } else {
                InfoBarCommand.toggle(executor, hero, null);
            }
        } else {
            executor.sendMessage(ChatColor.YELLOW + "The action bar cannot be disabled at this time.");
        }
        return true;
    }

    private static void toggle(CommandSender executor, Hero hero, Boolean mode) {
        if (mode == null) {
            hero.getRecordBar().setVisible(!hero.getRecordBar().isVisible());
        } else {
            hero.getRecordBar().setVisible(mode);
        }
        if (!hero.getRecordBar().isVisible()) {
            executor.sendMessage(ChatColor.GRAY + "Action bar " + ChatColor.RED + "disabled" + ChatColor.GRAY + "!");
        } else {
            executor.sendMessage(ChatColor.GRAY + "Action bar " + ChatColor.GREEN + "enabled" + ChatColor.GRAY + "!");
        }
    }
}

