/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.command.Command;
import com.herocraftonline.heroes.command.CommandHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.pagination.PaginatedResult;

public class HelpCommand
extends BasicCommand {
    private static final int CMDS_PER_PAGE = 8;
    private final Heroes plugin;
    private final HelpPaginatedResult paginatedResult = new HelpPaginatedResult();

    public HelpCommand(Heroes plugin) {
        super("Help");
        this.plugin = plugin;
        this.setDescription("Displays the help menu");
        this.setUsage("/hero help \u00a78[page#]");
        this.setArgumentRange(0, 1);
        this.setIdentifiers("hero", "hero help");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        int page = 1;
        if (args.length != 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        List<Command> sortCommands = this.plugin.getCommandHandler().getCommands();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Command command : sortCommands) {
            if (!command.isShownOnHelpMenu() || !CommandHandler.hasPermission(sender, command.getPermission())) continue;
            commands.add(command);
        }
        this.paginatedResult.display(sender, commands, page);
        return true;
    }

    public class HelpPaginatedResult
    extends PaginatedResult<Command> {
        public HelpPaginatedResult() {
            super(ChatColor.DARK_AQUA + "Heroes Help", "/hero {INDEX}");
        }

        @Override
        protected BaseComponent[] build(final Command entry, int index) {
            return ChatComponents.getCachedCommand(entry, new Callable<BaseComponent[]>(){

                @Override
                public BaseComponent[] call() {
                    ComponentBuilder builder = new ComponentBuilder("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("?").color(ChatUtil.toBungee(ChatColor.BLUE)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, HelpPaginatedResult.this.createDescription(entry))).append("] ").event((HoverEvent)null).color(ChatUtil.toBungee(ChatColor.WHITE)).append(entry.getUsage()).color(ChatUtil.toBungee(ChatColor.GRAY));
                    return builder.create();
                }
            });
        }

        private BaseComponent[] createDescription(Command command) {
            ComponentBuilder builder = new ComponentBuilder(command.getName()).color(ChatUtil.toBungee(ChatColor.BLUE)).append("\n").append("Description").color(ChatUtil.toBungee(ChatColor.DARK_AQUA)).append(": ").color(ChatUtil.toBungee(ChatColor.WHITE)).append(command.getDescription()).color(ChatUtil.toBungee(ChatColor.GRAY)).append("\n").append("Usage").color(ChatUtil.toBungee(ChatColor.DARK_AQUA)).append(": ").color(ChatUtil.toBungee(ChatColor.WHITE)).append(command.getUsage()).color(ChatUtil.toBungee(ChatColor.GRAY));
            return builder.create();
        }

        @Override
        protected void after(CommandSender viewer, ChatSendResult chatSendResult) {
            if (chatSendResult == ChatSendResult.FALLBACK) {
                viewer.sendMessage(ChatColor.GRAY + "For more information about a command, type " + ChatColor.GREEN + "/<command> ?");
            } else {
                viewer.sendMessage(ChatColor.GRAY + "For more information about a command, hover over the " + ChatComponents.BUTTON_QUESTION + ChatColor.GRAY + ".");
            }
        }

        @Override
        protected String buildFallback(Command entry, int index) {
            return "  " + ChatColor.GREEN + entry.getUsage();
        }
    }
}

