/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.command.BasicCommand;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CooldownCommand
extends BasicCommand {
    private final Heroes plugin;

    public CooldownCommand(Heroes plugin) {
        super("Cooldowns");
        this.plugin = plugin;
        this.setDescription("Displays your cooldowns");
        this.setUsage("/cd");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("cooldowns", "cd");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        Map<String, Long> cooldowns = hero.getCooldowns();
        if (cooldowns.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "You have no skills on cooldown.");
            return true;
        }
        long time = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : cooldowns.entrySet()) {
            if (entry.getKey().equals("global")) continue;
            Skill skill = this.plugin.getSkillManager().getSkill(entry.getKey());
            if (skill == null) {
                if (!Heroes.properties.debug) continue;
                Heroes.debugLog(Level.WARNING, "Attempted to display cooldown for non-existant skill: " + entry.getKey());
                continue;
            }
            long timeLeft = entry.getValue() - time;
            if (timeLeft <= 0L) continue;
            hero.getPlayer().sendMessage(ChatColor.WHITE + skill.getName() + ChatColor.GRAY + " has " + ChatColor.WHITE + timeLeft / 1000L + ChatColor.GRAY + " seconds left on cooldown!");
        }
        return true;
    }
}

