/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.events.AfterClassChangeEvent;
import com.herocraftonline.heroes.api.events.ClassChangeEvent;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.ultimate.UltimateClassDependencyUtil;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.util.Properties;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import to.hc.common.bukkit.chat.ChatSendResult;
import to.hc.common.bukkit.chat.ChatUtil;
import to.hc.common.bukkit.util.NMSHacks;

public class ChooseCommand
extends BasicInteractiveCommand {
    private final Heroes plugin;
    private final Map<String, HeroClass> pendingClassSelections = new HashMap<String, HeroClass>();
    private final Map<String, Double> pendingClassCostStatus = new HashMap<String, Double>();

    public ChooseCommand(Heroes plugin) {
        super("Choose Class");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Selects a path or specialization");
        this.setUsage("/hero choose \u00a79<type>");
    }

    @Override
    public String getCancelIdentifier() {
        return "hero cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingClassSelections.remove(executor.getName());
        this.pendingClassCostStatus.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("hero choose");
            this.setArgumentRange(1, 1);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Properties props = Heroes.properties;
            Player player = (Player)executor;
            Hero hero = ChooseCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getHeroClass();
            HeroClass newClass = ChooseCommand.this.plugin.getClassManager().getClass(args[0]);
            if (newClass == null) {
                player.sendMessage(ChatColor.RED + "Class not found.");
                return false;
            }
            Long cooldown = hero.getCooldown("class-change");
            if (cooldown != null && cooldown > System.currentTimeMillis()) {
                player.sendMessage(ChatColor.RED + "You've changed classes too recently. You must wait " + ChatColor.RED + (cooldown - System.currentTimeMillis()) / 1000L + ChatColor.GRAY + " seconds to change your class.");
                return false;
            }
            if (newClass.equals(currentClass) || newClass.equals(hero.getSecondaryClass())) {
                player.sendMessage(ChatColor.RED + "You are already set as this Class.");
                return false;
            }
            if (newClass.equals(currentClass) || newClass.equals(hero.getRaceClass())) {
                player.sendMessage(ChatColor.RED + "You are already set as this Race.");
                return false;
            }
            if (!currentClass.isDefault() && hero.isMaster(currentClass) && currentClass.getParents().isEmpty() && props.lockAtHighestTier) {
                player.sendMessage(ChatColor.RED + "You have mastered your class and can not choose a new one!");
                return false;
            }
            if (!newClass.isPrimary()) {
                player.sendMessage(ChatColor.RED + "That is not a primary Class!");
                return false;
            }
            if (!hero.isMaster(currentClass) && props.lockPathTillMaster) {
                player.sendMessage(ChatColor.RED + "You must master this class before swapping to another.");
                return false;
            }
            if (newClass.isUltimate()) {
                HeroClass.UltimateInfo info = newClass.getUltimateInfo();
                int count = info.getCount();
                int min = info.getMin();
                int max = info.getMax();
                Set<Integer> required = UltimateClassDependencyUtil.getRequiredHeroClassIds(player.getUniqueId(), count, min, max);
                for (Integer classId : required) {
                    String className = Properties.classIdMap[classId];
                    HeroClass hc = ChooseCommand.this.plugin.getClassManager().getClass(className);
                    if (hero.isMaster(hc)) continue;
                    player.sendMessage(ChatColor.GRAY + "You are not yet heroic enough to become a " + ChatColor.WHITE + newClass.getName());
                    return false;
                }
            }
            if (!newClass.hasNoParents()) {
                for (HeroClass parentClass : newClass.getStrongParents()) {
                    if (hero.isMaster(parentClass)) continue;
                    player.sendMessage(ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + " requires you to master: " + ChatColor.WHITE + newClass.getStrongParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
                boolean masteredOne = false;
                for (HeroClass parentClass : newClass.getWeakParents()) {
                    if (!hero.isMaster(parentClass)) continue;
                    masteredOne = true;
                    break;
                }
                if (!masteredOne && !newClass.getWeakParents().isEmpty()) {
                    player.sendMessage(ChatColor.WHITE + newClass.getName() + ChatColor.GRAY + " requires you to master one of: " + ChatColor.WHITE + newClass.getWeakParents().toString().replace("[", "").replace("]", ""));
                    return false;
                }
            }
            if (!newClass.isDefault() && !CommandHandler.hasPermission((CommandSender)player, "heroes.classes." + newClass.getName().toLowerCase())) {
                player.sendMessage(ChatColor.RED + "You don't have permission for " + newClass.getName() + ChatColor.GRAY + ".");
                return false;
            }
            double cost = newClass.getCost();
            if (hero.getExperience(newClass) > 0.0) {
                cost = props.oldClassSwapCost + props.oldClassSwapCostPerLevel * (double)hero.getHeroLevel(newClass);
            }
            if (props.swapWithMasteriesHasFullCost && hero.getMasteredClasses().size() >= props.numberOfMasteriesForFullCost) {
                cost = props.oldClassSwapCost + props.oldClassSwapCostPerLevel * (double)newClass.getMaxLevel();
            }
            if (props.firstSwitchFree && currentClass.isDefault()) {
                cost = 0.0;
            } else if (hero.isMaster(newClass) && props.swapMasterFree) {
                cost = 0.0;
            } else if (!props.economy || Heroes.econ == null || cost <= 0.0) {
                cost = 0.0;
            }
            if (props.economy && cost > 0.0 && !Heroes.econ.has((OfflinePlayer)player, cost)) {
                player.sendMessage(ChatColor.GRAY + "It will cost " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GRAY + " to switch professions, you only have " + ChatColor.WHITE + Heroes.econ.getBalance((OfflinePlayer)player));
                return false;
            }
            ChooseCommand.this.pendingClassCostStatus.put(player.getName(), cost);
            player.sendMessage(" ");
            executor.sendMessage(ChatColor.GRAY + "You have chosen...");
            executor.sendMessage(ChatColor.GREEN + "\u00bb  " + ChatColor.BLUE + newClass.getName() + ChatColor.WHITE + ": " + ChatColor.GRAY + newClass.getDescription().toLowerCase());
            if (cost > 0.0) {
                executor.sendMessage(ChatColor.WHITE + "Fee" + ChatColor.GRAY + ": " + ChatColor.WHITE + Heroes.econ.format(cost));
            }
            if (props.resetProfOnPrimaryChange) {
                executor.sendMessage(ChatColor.YELLOW + "Switching your primary class will also reset all experience toward your profession!");
            }
            if (props.resetRaceOnPrimaryChange) {
                executor.sendMessage(ChatColor.YELLOW + "Switching your primary class will also reset all experience toward your race!");
            }
            executor.sendMessage(" ");
            ChatComponents.ConfirmOrCancel.GENERIC.send(executor);
            ChooseCommand.this.pendingClassSelections.put(player.getName(), newClass);
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("hero confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return true;
            }
            Player player = (Player)executor;
            Hero hero = ChooseCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass currentClass = hero.getHeroClass();
            HeroClass newClass = ChooseCommand.this.pendingClassSelections.remove(player.getName());
            double cost = ChooseCommand.this.pendingClassCostStatus.remove(player.getName());
            Properties prop = Heroes.properties;
            ClassChangeEvent event = new ClassChangeEvent(hero, currentClass, newClass, cost);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                ChooseCommand.this.cancelInteraction((CommandSender)player);
                player.sendMessage(ChatColor.RED + "You're not allowed to join that class");
                return true;
            }
            cost = event.getCost();
            if (cost > 0.0) {
                if (Heroes.econ.has((OfflinePlayer)player, cost)) {
                    Heroes.econ.withdrawPlayer((OfflinePlayer)player, cost);
                    hero.getPlayer().sendMessage(ChatColor.RED + "The Gods are pleased with your offering of " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GRAY + ".");
                } else {
                    hero.getPlayer().sendMessage(ChatColor.RED + "You're unable to meet the offering of " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GRAY + " to become " + ChatColor.WHITE + newClass.getName());
                    return true;
                }
            }
            if (prop.resetExpOnClassChange && !hero.isMaster(currentClass) || prop.resetMasteryOnClassChange && hero.isMaster(currentClass)) {
                hero.setExperience(currentClass, 0.0);
            }
            hero.changeHeroClass(newClass, false, false);
            player.sendMessage(" ");
            player.sendMessage(" ");
            if (NMSHacks.sendMessage((CommandSender)player, this.newClassWelcome(newClass), null) != ChatSendResult.FAIL) {
                NMSHacks.sendMessage((CommandSender)player, this.newClassViewSkills(newClass), null);
            } else {
                player.sendMessage("\u00bb" + ChatColor.GRAY + "Welcome to the path of the " + ChatColor.BLUE + newClass.getName() + ChatColor.GRAY + "!");
                player.sendMessage("\u00bb" + ChatColor.GRAY + "View possible skills with " + ChatColor.BLUE + "/skills " + newClass.getName() + ChatColor.GRAY + ".");
            }
            if (prop.resetProfOnPrimaryChange && hero.getSecondaryClass() != null) {
                hero.setExperience(hero.getSecondaryClass(), 0.0);
            }
            if (prop.resetRaceOnPrimaryChange && hero.getRaceClass() != null) {
                hero.setExperience(hero.getRaceClass(), 0.0);
            }
            hero.setCooldown("class-change", System.currentTimeMillis() + Properties.classCooldown);
            ChooseCommand.this.plugin.getCharacterManager().saveHero(hero, false);
            AfterClassChangeEvent afterEvent = new AfterClassChangeEvent(hero, currentClass, newClass, cost);
            Bukkit.getPluginManager().callEvent((Event)afterEvent);
            if (afterEvent.isCancelled()) {
                ChooseCommand.this.cancelInteraction((CommandSender)player);
                return true;
            }
            return true;
        }

        private BaseComponent[] newClassWelcome(HeroClass clazz) {
            return new ComponentBuilder("Welcome to the path of the ").color(ChatUtil.toBungee(ChatColor.GRAY)).append(clazz.getName()).color(ChatUtil.toBungee(ChatColor.BLUE)).append("!").color(ChatUtil.toBungee(ChatColor.GRAY)).create();
        }

        private BaseComponent[] newClassViewSkills(HeroClass clazz) {
            String name = clazz.getName();
            return new ComponentBuilder("View ").color(ChatUtil.toBungee(ChatColor.GRAY)).append(name).color(ChatUtil.toBungee(ChatColor.BLUE)).append(" skills by ").color(ChatUtil.toBungee(ChatColor.GRAY)).append("[").color(ChatUtil.toBungee(ChatColor.WHITE)).append("clicking here").color(ChatUtil.toBungee(ChatColor.GOLD)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/skills " + name)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("/skills " + name).color(ChatUtil.toBungee(ChatColor.GOLD)).create())).append("]").color(ChatUtil.toBungee(ChatColor.WHITE)).event((ClickEvent)null).event((HoverEvent)null).append(".").color(ChatUtil.toBungee(ChatColor.GRAY)).create();
        }
    }
}

