/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.effects.common.ExpBoostEffect;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.listeners.ExpBoostListener;
import com.herocraftonline.heroes.util.TimeUtil;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BoostCommand
extends BasicCommand {
    private final Heroes plugin;

    public BoostCommand(Heroes plugin) {
        super("Boost");
        this.plugin = plugin;
        this.setDescription("Shows how much time left on a boost.");
        this.setUsage("/boost");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("boost");
        this.setPermission("heroes.boost");
    }

    @Override
    public boolean execute(CommandSender executor, String identifier, String[] args) {
        Hero hero = null;
        if (executor instanceof Player) {
            hero = this.plugin.getCharacterManager().getHero((Player)executor);
        }
        BoostCommand.showBoostInfo(executor, hero);
        return true;
    }

    static void showBoostInfo(CommandSender receiver, @Nullable Hero hero) {
        long timeRemaining = Heroes.properties.expiration - System.currentTimeMillis();
        if (timeRemaining > 0L) {
            receiver.sendMessage(ChatColor.GRAY + "The " + ChatColor.WHITE + (int)((Heroes.properties.expBonus - 1.0) * 100.0) + ChatColor.GRAY + "% boost expires in " + ChatColor.WHITE + TimeUtil.calculateTime(timeRemaining));
        } else {
            receiver.sendMessage(ChatColor.GRAY + "No boost active! Type /buy to view!");
        }
        if (hero != null) {
            ExpBoostEffect transientBoostEffect = ExpBoostListener.getTransientBoostEffect(hero);
            double passiveBoostMultiplier = ExpBoostListener.getCurrentBoost(hero, false);
            boolean showPassive = true;
            if (transientBoostEffect != null) {
                double transientPersonalBoostMultiplier = transientBoostEffect.getExpMultiplier();
                assert (transientPersonalBoostMultiplier >= 1.0);
                if (!transientBoostEffect.shouldStack()) {
                    if (passiveBoostMultiplier < transientPersonalBoostMultiplier) {
                        showPassive = false;
                        receiver.sendMessage(ChatColor.GRAY + "You also have a personal " + ChatColor.WHITE + (int)((transientPersonalBoostMultiplier - 1.0) * 100.0) + ChatColor.GRAY + "% boost which expires in " + ChatColor.WHITE + TimeUtil.calculateTime(transientBoostEffect.getRemainingTime()));
                    }
                } else {
                    receiver.sendMessage(ChatColor.GRAY + "You also have a personal " + ChatColor.WHITE + (int)((transientPersonalBoostMultiplier - 1.0) * 100.0) + ChatColor.GRAY + "% boost which expires in " + ChatColor.WHITE + TimeUtil.calculateTime(transientBoostEffect.getRemainingTime()));
                }
            }
            if (showPassive && passiveBoostMultiplier > 1.0) {
                receiver.sendMessage(ChatColor.GRAY + "You also have a passive exp boost of " + ChatColor.WHITE + (passiveBoostMultiplier - 1.0) * 100.0 + ChatColor.GRAY + "%");
            }
        }
    }
}

