/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.PassiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillType;
import com.herocraftonline.heroes.command.BasicCommand;
import com.herocraftonline.heroes.nms.NMSHandler;
import com.herocraftonline.heroes.util.MaterialUtil;
import com.herocraftonline.heroes.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BindSkillCommand
extends BasicCommand {
    private final Heroes plugin;

    public BindSkillCommand(Heroes plugin) {
        super("BindSkill");
        this.plugin = plugin;
        this.setDescription("Binds a skill with an item");
        this.setUsage("/bind \u00a79<skill> \u00a78[args]");
        this.setArgumentRange(0, 1000);
        this.setIdentifiers("bind", "unbind");
        this.setPermission("heroes.bind");
    }

    @Override
    public boolean execute(CommandSender sender, String identifier, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        Hero hero = this.plugin.getCharacterManager().getHero(player);
        ItemStack itemStack = NMSHandler.getInterface().getItemInMainHand(player.getInventory());
        if (itemStack == null || !hero.resolveWeapon() || Util.isFood(itemStack.getType())) {
            return false;
        }
        Material material = itemStack.getType();
        if (args.length > 0) {
            Skill skill = this.plugin.getSkillManager().getSkill(args[0]);
            if (skill == null) {
                skill = this.plugin.getSkillManager().getSkillFromIdent("skill " + args[0], sender);
            }
            if (skill != null && hero.canUseSkill(skill.getName())) {
                if (skill instanceof PassiveSkill || skill instanceof OutsourcedSkill) {
                    player.sendMessage(ChatColor.RED + "You can not bind passive skills!");
                    return false;
                }
                if (skill.isType(SkillType.UNBINDABLE)) {
                    player.sendMessage(ChatColor.RED + "You can not bind that skill!");
                    return false;
                }
                if (material == Material.AIR) {
                    player.sendMessage(ChatColor.RED + "You must be holding an item to bind a skill!");
                    return false;
                }
                hero.bind(material, args);
                sender.sendMessage(ChatColor.WHITE + MaterialUtil.getFriendlyName(material) + ChatColor.GRAY + " has been bound to " + ChatColor.WHITE + skill.getName() + ChatColor.GRAY + ".");
            } else {
                sender.sendMessage(ChatColor.RED + (hero.hasAccessToSkill(skill) ? "You can not currently use that skill." : "That skill does not exist for your class."));
            }
        } else {
            hero.unbind(material);
            sender.sendMessage(ChatColor.YELLOW + MaterialUtil.getFriendlyName(material) + " is no longer bound to a skill.");
        }
        return true;
    }
}

