/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.command.commands;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.chat.ChatComponents;
import com.herocraftonline.heroes.command.BasicInteractiveCommand;
import com.herocraftonline.heroes.command.BasicInteractiveCommandState;
import com.herocraftonline.heroes.util.Properties;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AttributeResetCommand
extends BasicInteractiveCommand {
    private final Heroes plugin;
    private final Map<String, Double> pendingClassCostStatus = new HashMap<String, Double>();

    public AttributeResetCommand(Heroes plugin) {
        super("Attribute Reset");
        this.plugin = plugin;
        this.setStates(new StateA(), new StateB());
        this.setDescription("Reset your attribute allocations");
        this.setUsage("/attribute reset");
        this.setArgumentRange(0, 0);
        this.setIdentifiers("hero attribute reset", "attribute reset");
    }

    @Override
    public String getCancelIdentifier() {
        return "attribute reset cancel";
    }

    @Override
    public void onCommandCancelled(CommandSender executor) {
        if (!(executor instanceof Player)) {
            return;
        }
        this.pendingClassCostStatus.remove(executor.getName());
    }

    class StateA
    extends BasicInteractiveCommandState {
        public StateA() {
            super("attribute reset");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return false;
            }
            Player player = (Player)executor;
            Properties props = Heroes.properties;
            double cost = 0.0;
            if (!props.economy || Heroes.econ == null || cost < 0.0) {
                cost = 0.0;
            }
            cost = props.attributeResetCost;
            if (props.economy && cost > 0.0 && !Heroes.econ.has((OfflinePlayer)player, cost)) {
                player.sendMessage(ChatColor.GRAY + "It will cost " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GRAY + " to reset your attribute allocations, but you only have " + ChatColor.WHITE + Heroes.econ.getBalance((OfflinePlayer)player));
                return false;
            }
            if (cost > 0.0) {
                executor.sendMessage(ChatColor.WHITE + "Fee" + ChatColor.GRAY + ": " + ChatColor.WHITE + Heroes.econ.format(cost));
            }
            AttributeResetCommand.this.pendingClassCostStatus.put(player.getName(), cost);
            executor.sendMessage(ChatColor.YELLOW + "You are about to reset " + ChatColor.RED + ChatColor.BOLD + "all" + ChatColor.RESET + ChatColor.YELLOW + " of your allocated attributes.");
            ChatComponents.ConfirmOrCancel.ATTRIBUTE_RESET.send(executor);
            return true;
        }
    }

    class StateB
    extends BasicInteractiveCommandState {
        public StateB() {
            super("attribute reset confirm");
            this.setArgumentRange(0, 0);
        }

        @Override
        public boolean execute(CommandSender executor, String identifier, String[] args) {
            if (!(executor instanceof Player)) {
                return true;
            }
            Player player = (Player)executor;
            Hero hero = AttributeResetCommand.this.plugin.getCharacterManager().getHero(player);
            HeroClass hc = hero.getHeroClass();
            int exp = (int)hero.getExperience(hc);
            int level = Properties.getLevel(exp);
            double cost = AttributeResetCommand.this.pendingClassCostStatus.remove(player.getName());
            if (cost > 0.0) {
                if (Heroes.econ.has((OfflinePlayer)player, cost)) {
                    Heroes.econ.withdrawPlayer((OfflinePlayer)player, cost);
                    executor.sendMessage(ChatColor.GREEN + "The Gods are pleased with your offering of " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.GREEN + ".");
                } else {
                    executor.sendMessage(ChatColor.RED + "You're unable to meet the offering of " + ChatColor.WHITE + Heroes.econ.format(cost) + ChatColor.RED + "to reset your attribute allocations.");
                    return true;
                }
            }
            hero.clearClassAttributeAllocations();
            hero.setAllocationPoints((level - 1) * hc.getAllocationPointsPerLevel());
            executor.sendMessage(ChatColor.GRAY + "You have successfully reset your attributes allocations.");
            return true;
        }
    }
}

